/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes a voxel-wise thickness of three-dimensional objects.
class IMAGEDEV_CPP_API LocalThicknessMap3d final : public GenericAlgorithm
{
public:
    /// The precision of the thickness computation.
    enum Precision
    {
    /// The operation is computed with the precise mode.
        FASTER = 0,
    /// The operation is computed with the fast mode.
        PRECISE
    };

    // Command constructor.
    LocalThicknessMap3d();


    /// Gets the inputBinaryImage parameter.
    /// The binary input image.
    std::shared_ptr< iolink::ImageView > inputBinaryImage() const;
    /// Sets the inputBinaryImage parameter.
    /// The binary input image.
    void setInputBinaryImage( std::shared_ptr< iolink::ImageView > inputBinaryImage );

    /// Gets the precision parameter.
    /// The precision of the thickness computation.
    LocalThicknessMap3d::Precision precision() const;
    /// Sets the precision parameter.
    /// The precision of the thickness computation.
    void setPrecision( const LocalThicknessMap3d::Precision& precision );

    /// Gets the outputMapImage parameter.
    /// The thickness map output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
    std::shared_ptr< iolink::ImageView > outputMapImage() const;
    /// Sets the outputMapImage parameter.
    /// The thickness map output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
    void setOutputMapImage( std::shared_ptr< iolink::ImageView > outputMapImage );

    // Method to launch the command.
    void execute();

};

/// Computes a voxel-wise thickness of three-dimensional objects.
/// @param inputBinaryImage The binary input image.
/// @param precision The precision of the thickness computation.
/// @param outputMapImage The thickness map output image. Its dimensions are forced to the same values as the input. Its data type is 32-bit floating point.
/// @return Returns the outputMapImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
localThicknessMap3d( std::shared_ptr< iolink::ImageView > inputBinaryImage,
                     LocalThicknessMap3d::Precision precision,
                     std::shared_ptr< iolink::ImageView > outputMapImage = nullptr );
} // namespace imagedev
