/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Computes a new image considering the dynamic range of a reference one.
class IMAGEDEV_CPP_API MatchContrast final : public GenericAlgorithm
{
public:
    /// The matching mode.
    enum MatchingMode
    {
    /// The computation is based on the intensity mean and variance values of the image.
        MEAN_VARIANCE = 0,
    /// The computation is based on the histogram of the image.
        HISTOGRAM
    };

    // Command constructor.
    MatchContrast();


    /// Gets the inputImage parameter.
    /// The model input image (the image to dynamically register).
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The model input image (the image to dynamically register).
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the inputReferenceImage parameter.
    /// The reference image. Its type must be the same as the model. Its dimensions can be different.
    std::shared_ptr< iolink::ImageView > inputReferenceImage() const;
    /// Sets the inputReferenceImage parameter.
    /// The reference image. Its type must be the same as the model. Its dimensions can be different.
    void setInputReferenceImage( std::shared_ptr< iolink::ImageView > inputReferenceImage );

    /// Gets the matchingMode parameter.
    /// The matching mode.
    MatchContrast::MatchingMode matchingMode() const;
    /// Sets the matchingMode parameter.
    /// The matching mode.
    void setMatchingMode( const MatchContrast::MatchingMode& matchingMode );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the model input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the model input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Computes a new image considering the dynamic range of a reference one.
/// @param inputImage The model input image (the image to dynamically register).
/// @param inputReferenceImage The reference image. Its type must be the same as the model. Its dimensions can be different.
/// @param matchingMode The matching mode.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the model input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
matchContrast( std::shared_ptr< iolink::ImageView > inputImage,
               std::shared_ptr< iolink::ImageView > inputReferenceImage,
               MatchContrast::MatchingMode matchingMode,
               std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
