/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Adaptive filter denoising a two-dimensional image.
class IMAGEDEV_CPP_API NonLocalMeansFilter2d final : public GenericAlgorithm
{
public:
    /// The shape of the search window.
    enum KernelShape
    {
    /// The search window is a square.
        SQUARE = 0,
    /// The search window is a disk.
        DISK
    };

    // Command constructor.
    NonLocalMeansFilter2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the patchRadius parameter.
    /// The patch box half size side length, in pixels.
    uint32_t patchRadius() const;
    /// Sets the patchRadius parameter.
    /// The patch box half size side length, in pixels.
    void setPatchRadius( const uint32_t& patchRadius );

    /// Gets the kernelRadius parameter.
    /// The search window half size side length or radius, in pixels.
    uint32_t kernelRadius() const;
    /// Sets the kernelRadius parameter.
    /// The search window half size side length or radius, in pixels.
    void setKernelRadius( const uint32_t& kernelRadius );

    /// Gets the similarity parameter.
    /// The similarity is used to compute weight w(k,n) assigned to each pixel in the search window.
    double similarity() const;
    /// Sets the similarity parameter.
    /// The similarity is used to compute weight w(k,n) assigned to each pixel in the search window.
    void setSimilarity( const double& similarity );

    /// Gets the kernelShape parameter.
    /// The shape of the search window.
    NonLocalMeansFilter2d::KernelShape kernelShape() const;
    /// Sets the kernelShape parameter.
    /// The shape of the search window.
    void setKernelShape( const NonLocalMeansFilter2d::KernelShape& kernelShape );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions, type, and calibration are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Adaptive filter denoising a two-dimensional image.
/// @param inputImage The input image.
/// @param patchRadius The patch box half size side length, in pixels.
/// @param kernelRadius The search window half size side length or radius, in pixels.
/// @param similarity The similarity is used to compute weight w(k,n) assigned to each pixel in the search window.
/// @param kernelShape The shape of the search window.
/// @param outputImage The output image. Its dimensions, type, and calibration are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
nonLocalMeansFilter2d( std::shared_ptr< iolink::ImageView > inputImage,
                       uint32_t patchRadius,
                       uint32_t kernelRadius,
                       double similarity,
                       NonLocalMeansFilter2d::KernelShape kernelShape,
                       std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
