/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/ObjectCountMsr.h>

namespace imagedev
{
// Output structure of the objectCount function.
struct ObjectCountOutput
{
    /// The label output image.
    std::shared_ptr< iolink::ImageView > outputLabelImage;
    /// The output measurement result.
    ObjectCountMsr::Ptr outputMeasurement;
};

/// Computes the number of objects in a binary or label image.
class IMAGEDEV_CPP_API ObjectCount final : public GenericAlgorithm
{
public:

    // Command constructor.
    ObjectCount();


    /// Gets the inputObjectImage parameter.
    /// The binary or label input image.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The binary or label input image.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the outputLabelImage parameter.
    /// The label output image.
    std::shared_ptr< iolink::ImageView > outputLabelImage() const;
    /// Sets the outputLabelImage parameter.
    /// The label output image.
    void setOutputLabelImage( std::shared_ptr< iolink::ImageView > outputLabelImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result.
    ObjectCountMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes the number of objects in a binary or label image.
/// @param inputObjectImage The binary or label input image.
/// @param outputLabelImage The label output image.
/// @param outputMeasurement The output measurement result.
/// @return Returns a ObjectCountOutput structure containing the outputLabelImage and outputMeasurement output parameters.
IMAGEDEV_CPP_API 
ObjectCountOutput
objectCount( std::shared_ptr< iolink::ImageView > inputObjectImage,
             std::shared_ptr< iolink::ImageView > outputLabelImage = nullptr,
             ObjectCountMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
