/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Pastes a two-dimensional image into another at a given location.
class IMAGEDEV_CPP_API PasteImage2d final : public GenericAlgorithm
{
public:

    // Command constructor.
    PasteImage2d();


    /// Gets the inputSource parameter.
    /// The input source image to be pasted in the destination image.
    std::shared_ptr< iolink::ImageView > inputSource() const;
    /// Sets the inputSource parameter.
    /// The input source image to be pasted in the destination image.
    void setInputSource( std::shared_ptr< iolink::ImageView > inputSource );

    /// Gets the inputDestination parameter.
    /// The input destination image.
    std::shared_ptr< iolink::ImageView > inputDestination() const;
    /// Sets the inputDestination parameter.
    /// The input destination image.
    void setInputDestination( std::shared_ptr< iolink::ImageView > inputDestination );

    /// Gets the originSource parameter.
    /// The origin of the region to paste in the destination image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
    iolink::Vector2i32 originSource() const;
    /// Sets the originSource parameter.
    /// The origin of the region to paste in the destination image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
    void setOriginSource( const iolink::Vector2i32& originSource );

    /// Gets the originDestination parameter.
    /// The origin of the region to paste in the source image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
    iolink::Vector2i32 originDestination() const;
    /// Sets the originDestination parameter.
    /// The origin of the region to paste in the source image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
    void setOriginDestination( const iolink::Vector2i32& originDestination );

    /// Gets the areaSize parameter.
    /// The size of the region to select, in pixels.
    iolink::Vector2u32 areaSize() const;
    /// Sets the areaSize parameter.
    /// The size of the region to select, in pixels.
    void setAreaSize( const iolink::Vector2u32& areaSize );

    /// Gets the outputImage parameter.
    /// The output image where the input image is pasted. Its dimensions and type are forced to the same values as the destination input image.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image where the input image is pasted. Its dimensions and type are forced to the same values as the destination input image.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Pastes a two-dimensional image into another at a given location.
/// @param inputSource The input source image to be pasted in the destination image.
/// @param inputDestination The input destination image.
/// @param originSource The origin of the region to paste in the destination image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
/// @param originDestination The origin of the region to paste in the source image, expressed in pixel coordinates. If the value is set outside the image, nothing is done.
/// @param areaSize The size of the region to select, in pixels.
/// @param outputImage The output image where the input image is pasted. Its dimensions and type are forced to the same values as the destination input image.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
pasteImage2d( std::shared_ptr< iolink::ImageView > inputSource,
              std::shared_ptr< iolink::ImageView > inputDestination,
              const iolink::Vector2i32& originSource,
              const iolink::Vector2i32& originDestination,
              const iolink::Vector2u32& areaSize,
              std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
