/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Performs a three-dimensional gradient projection with a directional vector defined by a center point.
class IMAGEDEV_CPP_API RadialGradientCentered3d final : public GenericAlgorithm
{
public:

    // Command constructor.
    RadialGradientCentered3d();


    /// Gets the inputImageX parameter.
    /// The X-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageX() const;
    /// Sets the inputImageX parameter.
    /// The X-gradient input image.
    void setInputImageX( std::shared_ptr< iolink::ImageView > inputImageX );

    /// Gets the inputImageY parameter.
    /// The Y-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageY() const;
    /// Sets the inputImageY parameter.
    /// The Y-gradient input image.
    void setInputImageY( std::shared_ptr< iolink::ImageView > inputImageY );

    /// Gets the inputImageZ parameter.
    /// The Z-gradient input image.
    std::shared_ptr< iolink::ImageView > inputImageZ() const;
    /// Sets the inputImageZ parameter.
    /// The Z-gradient input image.
    void setInputImageZ( std::shared_ptr< iolink::ImageView > inputImageZ );

    /// Gets the projectionCenter parameter.
    /// The center of projection coordinates.
    iolink::Vector3i32 projectionCenter() const;
    /// Sets the projectionCenter parameter.
    /// The center of projection coordinates.
    void setProjectionCenter( const iolink::Vector3i32& projectionCenter );

    /// Gets the outputNormalImage parameter.
    /// The normal gradient output image.
    std::shared_ptr< iolink::ImageView > outputNormalImage() const;
    /// Sets the outputNormalImage parameter.
    /// The normal gradient output image.
    void setOutputNormalImage( std::shared_ptr< iolink::ImageView > outputNormalImage );

    // Method to launch the command.
    void execute();

};

/// Performs a three-dimensional gradient projection with a directional vector defined by a center point.
/// @param inputImageX The X-gradient input image.
/// @param inputImageY The Y-gradient input image.
/// @param inputImageZ The Z-gradient input image.
/// @param projectionCenter The center of projection coordinates.
/// @param outputNormalImage The normal gradient output image.
/// @return Returns the outputNormalImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
radialGradientCentered3d( std::shared_ptr< iolink::ImageView > inputImageX,
                          std::shared_ptr< iolink::ImageView > inputImageY,
                          std::shared_ptr< iolink::ImageView > inputImageZ,
                          const iolink::Vector3i32& projectionCenter,
                          std::shared_ptr< iolink::ImageView > outputNormalImage = nullptr );
} // namespace imagedev
