/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/ArrayX.h>
#include <memory>

namespace imagedev
{
/// Reads a file containing an ArrayXi64 object.
class IMAGEDEV_CPP_API ReadArrayXi64 final : public GenericAlgorithm
{
public:

    // Command constructor.
    ReadArrayXi64();


    /// Gets the filePath parameter.
    /// The path of the ArrayXi64 to read.
    std::string filePath() const;
    /// Sets the filePath parameter.
    /// The path of the ArrayXi64 to read.
    void setFilePath( const std::string& filePath );

    /// Gets the outputArrayXi64 parameter.
    /// The ArrayXi64 object read in the file.
    std::shared_ptr<iolink::ArrayXi64> outputArrayXi64() const;
    /// Sets the outputArrayXi64 parameter.
    /// The ArrayXi64 object read in the file.
    void setOutputArrayXi64( std::shared_ptr<iolink::ArrayXi64> outputArrayXi64 );

    // Method to launch the command.
    void execute();

};

/// Reads a file containing an ArrayXi64 object.
/// @param filePath The path of the ArrayXi64 to read.
/// @param outputArrayXi64 The ArrayXi64 object read in the file.
/// @return Returns the outputArrayXi64 output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr<iolink::ArrayXi64>
readArrayXi64( const std::string& filePath, std::shared_ptr<iolink::ArrayXi64> outputArrayXi64 = nullptr );
} // namespace imagedev
