/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <ImageDev/Data/Model/OnnxModel.h>

namespace imagedev
{
/// Loads an ONNX model in a persistant object in memory.
class IMAGEDEV_CPP_API ReadOnnxModel final : public GenericAlgorithm
{
public:

    // Command constructor.
    ReadOnnxModel();


    /// Gets the filePath parameter.
    /// The path of the ONNX model file.
    std::string filePath() const;
    /// Sets the filePath parameter.
    /// The path of the ONNX model file.
    void setFilePath( const std::string& filePath );

    /// Gets the outputOnnxModel parameter.
    /// The Object containing the ONNX model.
    OnnxModel::Ptr outputOnnxModel() const;

    // Method to launch the command.
    void execute();

};

/// Loads an ONNX model in a persistant object in memory.
/// @param filePath The path of the ONNX model file.
/// @param outputOnnxModel The Object containing the ONNX model.
/// @return Returns the outputOnnxModel output parameter.
IMAGEDEV_CPP_API 
OnnxModel::Ptr
readOnnxModel( const std::string& filePath, OnnxModel::Ptr outputOnnxModel = nullptr );
} // namespace imagedev
