/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Generates a three-dimensional image with a new size using a user-defined interpolation mode.
class IMAGEDEV_CPP_API Resize3d final : public GenericAlgorithm
{
public:
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    enum InterpolationType
    {
    /// Assign the gray level of the nearest pixel.
        NEAREST_NEIGHBOR = 0,
    /// Assign the bilinear interpolation from the four nearest pixels.
        LINEAR
    };

    // Command constructor.
    Resize3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the shape parameter.
    /// The X, Y and Z size of the new image, in pixels.
    iolink::Vector3i32 shape() const;
    /// Sets the shape parameter.
    /// The X, Y and Z size of the new image, in pixels.
    void setShape( const iolink::Vector3i32& shape );

    /// Gets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    Resize3d::InterpolationType interpolationType() const;
    /// Sets the interpolationType parameter.
    /// The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
    void setInterpolationType( const Resize3d::InterpolationType& interpolationType );

    /// Gets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its dimensions are defined by the shape parameter.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its dimensions are defined by the shape parameter.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Generates a three-dimensional image with a new size using a user-defined interpolation mode.
/// @param inputImage The input image.
/// @param shape The X, Y and Z size of the new image, in pixels.
/// @param interpolationType The interpolation mode. Method used to calculate the intensity of each pixel in the result image.
/// @param outputImage The output image. Its type is forced to the same value as the input. Its dimensions are defined by the shape parameter.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
resize3d( std::shared_ptr< iolink::ImageView > inputImage,
          const iolink::Vector3i32& shape,
          Resize3d::InterpolationType interpolationType,
          std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
