/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/SimilarityMetricValueMsr.h>

namespace imagedev
{
/// Computes a similarity criterion between two images and outputs the corresponding metric value.
class IMAGEDEV_CPP_API SimilarityMetricValue final : public GenericAlgorithm
{
public:
    /// The metric used to compare both input images
    enum MetricType
    {
    /// The computed metric is the mean-squared error.
        MEAN_SQUARE_ERROR = 0,
    /// The computed metric is the correlation between both images, normalized in mean and variance.
        CORRELATION,
    /// The computed metric is the peak signal-to-noise ratio between both images in dB.
        PEAK_SIGNAL_TO_NOISE_RATIO
    };

    // Command constructor.
    SimilarityMetricValue();


    /// Gets the inputImage1 parameter.
    /// The first input image to compare.
    std::shared_ptr< iolink::ImageView > inputImage1() const;
    /// Sets the inputImage1 parameter.
    /// The first input image to compare.
    void setInputImage1( std::shared_ptr< iolink::ImageView > inputImage1 );

    /// Gets the inputImage2 parameter.
    /// The second input image to compare. Its dimensions and type must be the same as the first input.
    std::shared_ptr< iolink::ImageView > inputImage2() const;
    /// Sets the inputImage2 parameter.
    /// The second input image to compare. Its dimensions and type must be the same as the first input.
    void setInputImage2( std::shared_ptr< iolink::ImageView > inputImage2 );

    /// Gets the metricType parameter.
    /// The metric used to compare both input images
    SimilarityMetricValue::MetricType metricType() const;
    /// Sets the metricType parameter.
    /// The metric used to compare both input images
    void setMetricType( const SimilarityMetricValue::MetricType& metricType );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result containing the similarity value in accordance with the selected metric.
    SimilarityMetricValueMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes a similarity criterion between two images and outputs the corresponding metric value.
/// @param inputImage1 The first input image to compare.
/// @param inputImage2 The second input image to compare. Its dimensions and type must be the same as the first input.
/// @param metricType The metric used to compare both input images
/// @param outputMeasurement The output measurement result containing the similarity value in accordance with the selected metric.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
SimilarityMetricValueMsr::Ptr
similarityMetricValue( std::shared_ptr< iolink::ImageView > inputImage1,
                       std::shared_ptr< iolink::ImageView > inputImage2,
                       SimilarityMetricValue::MetricType metricType,
                       SimilarityMetricValueMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
