/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/Vector.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Translates a two-dimensional image by a user-defined vector.
class IMAGEDEV_CPP_API TranslateImage2d final : public GenericAlgorithm
{
public:
    /// The mode for managing outside information.
    enum BackgroundMode
    {
    /// The information moved outside of the image area is lost, and a padding value is assigned to the blank area counterpart.
        FIXED = 0,
    /// The image is perceived as a cylinder, where the information outside the image area wraps around and is placed in the blank part.
        LOOPED
    };

    // Command constructor.
    TranslateImage2d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the translationVector parameter.
    /// The translation vector, in pixels.
    iolink::Vector2i32 translationVector() const;
    /// Sets the translationVector parameter.
    /// The translation vector, in pixels.
    void setTranslationVector( const iolink::Vector2i32& translationVector );

    /// Gets the backgroundMode parameter.
    /// The mode for managing outside information.
    TranslateImage2d::BackgroundMode backgroundMode() const;
    /// Sets the backgroundMode parameter.
    /// The mode for managing outside information.
    void setBackgroundMode( const TranslateImage2d::BackgroundMode& backgroundMode );

    /// Gets the paddingValue parameter.
    /// The background value, used only in fixed background mode.
    double paddingValue() const;
    /// Sets the paddingValue parameter.
    /// The background value, used only in fixed background mode.
    void setPaddingValue( const double& paddingValue );

    /// Gets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its dimensions and type are forced to the same values as the input.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Translates a two-dimensional image by a user-defined vector.
/// @param inputImage The input image.
/// @param translationVector The translation vector, in pixels.
/// @param backgroundMode The mode for managing outside information.
/// @param paddingValue The background value, used only in fixed background mode.
/// @param outputImage The output image. Its dimensions and type are forced to the same values as the input.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
translateImage2d( std::shared_ptr< iolink::ImageView > inputImage,
                  const iolink::Vector2i32& translationVector,
                  TranslateImage2d::BackgroundMode backgroundMode,
                  double paddingValue,
                  std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
