/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Swaps coordinates of a three-dimensional image.
class IMAGEDEV_CPP_API TransposeImage3d final : public GenericAlgorithm
{
public:
    /// The transposition mode.
    enum TranspositionMode
    {
    /// Use the transform O(i,j,k) = I(j,i,k)
        XYZ_TO_YXZ = 0,
    /// Use the transform O(i,j,k) = I(i,k,j)
        XYZ_TO_XZY,
    /// Use the transform O(i,j,k) = I(j,k,i)
        XYZ_TO_YZX,
    /// Use the transform O(i,j,k) = I(k,i,j)
        XYZ_TO_ZXY,
    /// Use the transform O(i,j,k) = I(k,j,i)
        XYZ_TO_ZYX
    };

    // Command constructor.
    TransposeImage3d();


    /// Gets the inputImage parameter.
    /// The input image.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the transpositionMode parameter.
    /// The transposition mode.
    TransposeImage3d::TranspositionMode transpositionMode() const;
    /// Sets the transpositionMode parameter.
    /// The transposition mode.
    void setTranspositionMode( const TransposeImage3d::TranspositionMode& transpositionMode );

    /// Gets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its X, Y, and Z dimensions are switched in accordance with the transposition mode.
    std::shared_ptr< iolink::ImageView > outputImage() const;
    /// Sets the outputImage parameter.
    /// The output image. Its type is forced to the same value as the input. Its X, Y, and Z dimensions are switched in accordance with the transposition mode.
    void setOutputImage( std::shared_ptr< iolink::ImageView > outputImage );

    // Method to launch the command.
    void execute();

};

/// Swaps coordinates of a three-dimensional image.
/// @param inputImage The input image.
/// @param transpositionMode The transposition mode.
/// @param outputImage The output image. Its type is forced to the same value as the input. Its X, Y, and Z dimensions are switched in accordance with the transposition mode.
/// @return Returns the outputImage output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
transposeImage3d( std::shared_ptr< iolink::ImageView > inputImage,
                  TransposeImage3d::TranspositionMode transpositionMode,
                  std::shared_ptr< iolink::ImageView > outputImage = nullptr );
} // namespace imagedev
