/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>
#include <ImageDev/Data/GlobalMeasurements/VolumeFractionByRegionMsr.h>

namespace imagedev
{
/// Computes, for each region of a first label image, the intersection ratio with particles of a second label image.
class IMAGEDEV_CPP_API VolumeFractionByRegion final : public GenericAlgorithm
{
public:

    // Command constructor.
    VolumeFractionByRegion();


    /// Gets the inputObjectImage parameter.
    /// The input binary or label image representing the regions to be analyzed.
    std::shared_ptr< iolink::ImageView > inputObjectImage() const;
    /// Sets the inputObjectImage parameter.
    /// The input binary or label image representing the regions to be analyzed.
    void setInputObjectImage( std::shared_ptr< iolink::ImageView > inputObjectImage );

    /// Gets the inputLabelImage parameter.
    /// The input label image containing the particles to be intersected with regions. This image must have same dimensions as the region input image.
    std::shared_ptr< iolink::ImageView > inputLabelImage() const;
    /// Sets the inputLabelImage parameter.
    /// The input label image containing the particles to be intersected with regions. This image must have same dimensions as the region input image.
    void setInputLabelImage( std::shared_ptr< iolink::ImageView > inputLabelImage );

    /// Gets the outputMeasurement parameter.
    /// The output measurement result providing the intersection ratio between each region and particle.
    VolumeFractionByRegionMsr::Ptr outputMeasurement() const;

    // Method to launch the command.
    void execute();

};

/// Computes, for each region of a first label image, the intersection ratio with particles of a second label image.
/// @param inputObjectImage The input binary or label image representing the regions to be analyzed.
/// @param inputLabelImage The input label image containing the particles to be intersected with regions. This image must have same dimensions as the region input image.
/// @param outputMeasurement The output measurement result providing the intersection ratio between each region and particle.
/// @return Returns the outputMeasurement output parameter.
IMAGEDEV_CPP_API 
VolumeFractionByRegionMsr::Ptr
volumeFractionByRegion( std::shared_ptr< iolink::ImageView > inputObjectImage,
                        std::shared_ptr< iolink::ImageView > inputLabelImage,
                        VolumeFractionByRegionMsr::Ptr outputMeasurement = nullptr );
} // namespace imagedev
