/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Converts a volume input into a sequence.
class IMAGEDEV_CPP_API VolumeToSequence final : public GenericAlgorithm
{
public:

    // Command constructor.
    VolumeToSequence();


    /// Gets the inputVolume parameter.
    /// The input 3d volume.
    std::shared_ptr< iolink::ImageView > inputVolume() const;
    /// Sets the inputVolume parameter.
    /// The input 3d volume.
    void setInputVolume( std::shared_ptr< iolink::ImageView > inputVolume );

    /// Gets the outputSequence parameter.
    /// The output 2d sequence. Its X, Y dimensions and type are forced to the same values as the input. Its sequence dimension is equal to the number of slices of the input.
    std::shared_ptr< iolink::ImageView > outputSequence() const;
    /// Sets the outputSequence parameter.
    /// The output 2d sequence. Its X, Y dimensions and type are forced to the same values as the input. Its sequence dimension is equal to the number of slices of the input.
    void setOutputSequence( std::shared_ptr< iolink::ImageView > outputSequence );

    // Method to launch the command.
    void execute();

};

/// Converts a volume input into a sequence.
/// @param inputVolume The input 3d volume.
/// @param outputSequence The output 2d sequence. Its X, Y dimensions and type are forced to the same values as the input. Its sequence dimension is equal to the number of slices of the input.
/// @return Returns the outputSequence output parameter.
IMAGEDEV_CPP_API 
std::shared_ptr< iolink::ImageView >
volumeToSequence( std::shared_ptr< iolink::ImageView > inputVolume, std::shared_ptr< iolink::ImageView > outputSequence = nullptr );
} // namespace imagedev
