/*=======================================================================
 ***         THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S,                  ***
 ***                   A PART OF THERMO FISHER SCIENTIFIC,                          ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC.       ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***   COPYRIGHT (C) 2021-2025 BY FEI S.A.S, A PART OF THERMO FISHER SCIENTIFIC,    ***
 ***                       BORDEAUX, FRANCE                                         ***
 ***                      ALL RIGHTS RESERVED                                       ***
 **=======================================================================*/
#pragma once

#include <ImageDev/Processing/GenericAlgorithm.h>
#include <ImageDev/ImageDevCppExports.h>
#include <ImageDev/Exception.h>
#include <iolink/view/ImageView.h>

namespace imagedev
{
/// Saves any image that has been generated with ImageDev on disk.
class IMAGEDEV_CPP_API WriteVipImage final : public GenericAlgorithm
{
public:

    // Command constructor.
    WriteVipImage();


    /// Gets the inputImage parameter.
    /// The input image to save on disk.
    std::shared_ptr< iolink::ImageView > inputImage() const;
    /// Sets the inputImage parameter.
    /// The input image to save on disk.
    void setInputImage( std::shared_ptr< iolink::ImageView > inputImage );

    /// Gets the filePath parameter.
    /// The path of the image file to save. Its recommended extension is ".vip".
    std::string filePath() const;
    /// Sets the filePath parameter.
    /// The path of the image file to save. Its recommended extension is ".vip".
    void setFilePath( const std::string& filePath );

    /// Gets the overwrite parameter.
    /// The decision to take if the file already exists. If true, an existing file is overwritten. If false, an exeption is thrown when the output file already exists.
    bool overwrite() const;
    /// Sets the overwrite parameter.
    /// The decision to take if the file already exists. If true, an existing file is overwritten. If false, an exeption is thrown when the output file already exists.
    void setOverwrite( const bool& overwrite );

    /// Gets the autoDetermineBestVersion parameter.
    /// The way to tag the VIP format version in the file. If true, the version is automatically identified.
    bool autoDetermineBestVersion() const;
    /// Sets the autoDetermineBestVersion parameter.
    /// The way to tag the VIP format version in the file. If true, the version is automatically identified.
    void setAutoDetermineBestVersion( const bool& autoDetermineBestVersion );

    /// Gets the fileFormatVersion parameter.
    /// The  VIP format version in the file to indicate in the file. This parameter is ignored if the autoDetermineBestVersion parameter is true.
    uint32_t fileFormatVersion() const;
    /// Sets the fileFormatVersion parameter.
    /// The  VIP format version in the file to indicate in the file. This parameter is ignored if the autoDetermineBestVersion parameter is true.
    void setFileFormatVersion( const uint32_t& fileFormatVersion );

    // Method to launch the command.
    void execute();

};

/// Saves any image that has been generated with ImageDev on disk.
/// @param inputImage The input image to save on disk.
/// @param filePath The path of the image file to save. Its recommended extension is ".vip".
/// @param overwrite The decision to take if the file already exists. If true, an existing file is overwritten. If false, an exeption is thrown when the output file already exists.
/// @param autoDetermineBestVersion The way to tag the VIP format version in the file. If true, the version is automatically identified.
/// @param fileFormatVersion The  VIP format version in the file to indicate in the file. This parameter is ignored if the autoDetermineBestVersion parameter is true.
/// @return Returns the None output parameter.
IMAGEDEV_CPP_API 
void
writeVipImage( std::shared_ptr< iolink::ImageView > inputImage,
               const std::string& filePath,
               bool overwrite,
               bool autoDetermineBestVersion,
               uint32_t fileFormatVersion );
} // namespace imagedev
