// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

namespace iolink
{

/**
 * This enum indicates how a multidimensionnal array
 * is stored in continuous memory.
 */
enum class MemoryLayout
{
  /** Unknown layout */
  UNKNOWN = 0,

  /** In the C layout the first dimension will have
   * the bigger stride.
   *
   * It is often called row major.
   *
   * The dimensions' indices are in reverse order
   * when accessing memory in that layout: array[j][i]
   *
   * | 11 | 12 | 13 | <br>
   * | 21 | 22 | 23 |
   *
   * Would be stored as such: {11, 21, 12, 22, 13, 23}
   */
  C,

  /** In the Fortran layout the first dimension will have
   * the lesser stride.
   *
   * It is often called column major.
   *
   * The dimensions' indices are in normal order
   * when accessing memory in that layout: array[i][j]
   *
   * | 11 | 12 | 13 | <br>
   * | 21 | 22 | 23 |
   *
   * Would be stored as such: {11, 12, 13, 21, 22, 23}
   */
  FORTRAN,
};

} // end namespace iolink
