// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/DataType.h>
#include <iolink/IOLinkAPI.h>

namespace iolink
{

/**
 * Stores metadata heterogeneous type value.
 *
 * This interfaces only give access to the type of data stored, and how many
 * of elements are stored. Values can be accessed by casting the raw pointer to
 * the corresponding type.
 */
class IOLINK_INTERFACE_API VariantDataValue
{
public:
  virtual ~VariantDataValue() = default;

  /**
   * Copies this value.
   */
  virtual std::shared_ptr<VariantDataValue> clone() const = 0;

  /**
   * Returns the type of the values stored.
   */
  virtual DataType type() const = 0;

  /**
   * Returns the number of values of the specified type stored.
   */
  virtual size_t count() const = 0;

  /**
   * Returns a pointer to the location where all the values are stored continuously.
   *
   * To ease raw value decoding, a helper called VariantDataValueConverter is available
   * to simply convert this VariantDataValue to basic types.
   *
   * @see VariantDataValueConverter
   */
  virtual const void* raw() const = 0;
};

} // end namespace iolink
