#pragma once
#include <memory>
#include <string>

#include <iolink/Indexer.h>
#include <iolink/cuda/api.h>
#include <iolink/view/Extension.h>

namespace iolink_cuda
{
/**
 * Extension of ImageView to give Cuda memory access
 */
class IOLINK_CUDA_API CudaImageExtension : public iolink::Extension
{
public:
  /**
   * Identifier used to load the extension using the View::extension method.
   */
  static constexpr size_t EXTENSION_ID = 0x0CDA0000;

  /**
   * Return an Indexer describing the memory layout of the buffer.
   */
  virtual const iolink::Indexer& indexer() = 0;

  /**
   * Return a mutable pointer to the internal CUDA memory buffer.
   */
  virtual void* buffer() = 0;

  /**
   * Return an immutable pointer to the internal CUDA memory buffer.
   */
  virtual const void* bufferReadOnly() const = 0;

  /**
   * Size in bytes of the CUDA internal buffer.
   */
  virtual size_t bufferSize() = 0;

  /**
   * Return the id of the device where the CUDA memory is allocated.
   */
  virtual int device() const = 0;
};

} // namespace iolink_cuda
