// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/DataType.h>
#include <iolink/IOLinkAPI.h>

namespace iolink
{

/**
 * Handle conversion of data buffers described by an IOLink DataType.
 */
class IOLINK_API DataConverter
{
public:
  /**
   * Convert each element of the source buffer into another data type and writes it into the
   * destination buffer.
   *
   * This method uses the simpliest way of converting data: static casting. So it is only compatible
   * with numeric types, and can lead to stranges values in specific cases.
   *
   * This method throws an exception when the arguments are invalid (null buffers for example),
   * when types aren't numeric ones, or when the source type is not convertible into the
   * destination one.
   *
   * @see DataType::isConvertibleTo
   *
   * @param srcType The type of data stored in the source buffer
   * @param src The source buffer
   * @param dstType The type of data stored in the destination buffer
   * @param dst The destination buffer
   * @param count The number of element to convert
   *
   * @throw Error
   */
  static void convert(DataType srcType, const void* src, DataType dstType, void* dst, size_t count);

  /**
   * This converter is used to revert endianness of a set of samples.
   *
   * This method throws an exception when the arguments are invalid (null buffers for example),
   * when given source type is not handled.
   *
   * @param srcType The type of data stored in the source buffer
   * @param src The source buffer
   * @param dst The destination buffer
   * @param count The number of element to convert
   *
   * @throw Error if given datatype is not handled
   */
  static void endianReverse(DataType srcType, const void* src, void* dst, size_t count);
};

} // end namespace iolink
