// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <iolink/IOLinkAPI.h>
#include <iolink/view/View.h>

namespace iolink
{

/**
 * Status of the research of a common ancestor
 */
enum class CommonAncestorStatus
{
  SHARE_NO_ANCESTOR, ///< Views share no common ancestor at all
  SHARE_ANCESTOR,    ///< Views share at least one common ancestor
  UNDETERMINED       ///< Information is not available, because the dependency tree is not complete
};

/**
 * Algorithms on the dependency graph.
 */
class IOLINK_API DependencyGraph
{
public:
  /**
   * @brief Indicates if two views share a common ancestor.
   *
   * @param view1 First view to take into account
   * @param view2 Second view to take into account
   *
   * @return SHARE_ANCESTOR if the two given views share at least one common ancestor.
   * @return SHARE_NO_ANCESTOR if the two given views don't share any ancestor.
   * @return UNDETERMINED if the information could not be determined (dependency graph is not complete).
   */
  static CommonAncestorStatus hasCommonAncestor(std::shared_ptr<View> view1, std::shared_ptr<View> view2);
};

} // namespace iolink
