// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2021 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
//        SEE https://developer.openinventor.com/MiscFiles/EULA.pdf FOR MORE        //
// ================================================================================ //

#pragma once

#include <memory>

#include <iolink/IOLinkAPI.h>
#include <iolink/view/Extension.h>
#include <iolink/view/ViewOriginExtension.h>

namespace iolink
{

/**
 * Interface representing a generic view on data.
 */
class IOLINK_API View
{
public:
  virtual ~View() = default;

  /**
   * Get an extension of the view, corresponding to the given identifier.
   *
   * @param id The extension identifier.
   *
   * @throw Error When the required extension is not available.
   *
   * @see Extension
   */
  virtual std::shared_ptr<Extension> extension(size_t id);

  /**
   * @brief Get an extension of the view, corresponding to the given type.
   *
   * @tparam T The extension type.
   */
  template <typename T>
  inline std::shared_ptr<T> extension()
  {
    return T::cast(this->extension(T::EXTENSION_ID));
  }

  /**
   * Shortcut to access to ViewOrigin extension
   */
  std::shared_ptr<ViewOriginExtension> viewOrigin();
};

} // namespace iolink
