// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2022 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
// SEE http://assets.thermofisher.com/TFS-Assets/MSD/Licensing-Information/FEI_SAS_Thermo-Fisher-EULA_GLOBAL_With Usage Log_Nov2020.pdf //
//                              FOR MORE INFORMATION.                               //
// ================================================================================ //

#pragma once

#include <iolink/Error.h>

namespace ioformat
{

/**
 * Exception representing an unsupported format.
 *
 * This exception can be thrown to indicate a limitation in IOFormat.
 * like unsupported file format, unsupported compression elgorithm, etc.
 */
class UnsupportedFormat final : public iolink::Error
{

public:
  explicit UnsupportedFormat(const char* msg)
      : iolink::Error(msg)
  {
  }
};

/**
 * Exception representing an unsupported operation.
 *
 * This exception can be thrown to indicate an operation is not supported
 * in IOFormat.
 *
 */
class UnsupportedOperation final : public iolink::Error
{

public:
  explicit UnsupportedOperation(const char* msg)
      : iolink::Error(msg)
  {
  }
};

/**
 * An Error that can be thrown by a Writer.
 */
class EncodingError final : public iolink::Error
{
public:
  explicit EncodingError(const char* msg)
      : iolink::Error(msg)
  {
  }
};

/**
 * An Error that can be thrown by a Reader.
 */
class DecodingError final : public iolink::Error
{
public:
  explicit DecodingError(const char* msg)
      : iolink::Error(msg)
  {
  }
};

} // namespace ioformat
