// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2022 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
// SEE http://assets.thermofisher.com/TFS-Assets/MSD/Licensing-Information/FEI_SAS_Thermo-Fisher-EULA_GLOBAL_With Usage Log_Nov2020.pdf //
//                              FOR MORE INFORMATION.                               //
// ================================================================================ //

#pragma once

#include <iolink/Logger.h>

#include <ioformat/IOFormatAPI.h>

namespace ioformat
{
class IOFORMAT_API Logger
{
public:
  /**
    Allows to initialize IOFormat with a specific log level.
    By default, IOFormat log level is initialized with IOLink log level, but this method allows to choose a
    different level from IOLink. This method must be called before any other IOFormat call, otherwise it won't have any
    effect.
  */
  static void init(iolink::LogLevel level);

  /**
    Allows to retrieve the current IOFormat log level.
  */
  static iolink::LogLevel logLevel();
};

} // end namespace ioformat