// ================================================================================ //
//       THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        //
//                  AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                   //
//                                                                                  //
//     REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS      //
//     SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR      //
//                       WRITTEN AUTHORIZATION OF FEI S.A.S.                        //
//                                                                                  //
//                             RESTRICTED RIGHTS LEGEND                             //
//     USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS     //
//     WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN     //
//     SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT     //
//     CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN     //
//        TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         //
//                                                                                  //
//                         COPYRIGHT (C) 2022 BY FEI S.A.S,                         //
//                                 BORDEAUX, FRANCE                                 //
//                               ALL RIGHTS RESERVED                                //
//                                                                                  //
// SEE http://assets.thermofisher.com/TFS-Assets/MSD/Licensing-Information/FEI_SAS_Thermo-Fisher-EULA_GLOBAL_With Usage Log_Nov2020.pdf //
//                              FOR MORE INFORMATION.                               //
// ================================================================================ //

#pragma once

#include <cstdint>
#include <string>

#include <ioformat/IOFormatAPI.h>
#include <ioformat/Version.h>

namespace ioformat
{

/**
 * Versioning tool to check library infos.
 */
class IOFORMAT_API Versioning
{
public:
  /**
   * Return the version of the currently loaded IOFormat library.
   */
  static VersionInfo version();

  /**
   * Return a description string of the currently loaded IOFormat library.
   */
  static std::string versionString();

  /**
   * @brief Return the SHA of the commit used to build this version of IOFormat.
   */
  static std::string sha();

  /**
   * Checks if the version of the loaded library is compatible with the one given in argument.
   *
   * A version is compatible if:
   *  - The major version is the same
   *  - The library minor version is greater than the given one.
   *
   * @param version The version to check compatibility for.
   */
  static bool checkCompatibility(const VersionInfo& version);

  /**
   * Check if the loaded library is compatible with the one defined in the header.
   */
  static inline bool checkCompatibility() { return checkCompatibility(IOFORMAT_VERSION); }
};

} // end namespace ioformat
