#include <ImageDev/ImageDev.h>
#include <ioformat/IOFormat.h>
#include <iolink/view/ImageViewProvider.h>
#include <string.h>

using namespace imagedev;
using namespace ioformat;
using namespace iolink;

int
main( int argc, char* argv[] )
{
    int status = 0;

    try
    {
        // ImageDev library initialization
        if ( imagedev::isInitialized() == false )
            imagedev::init();

        // Open a tif file
        auto imageInput = readImage( std::string( IMAGEDEVDATA_IMAGES_FOLDER ) + "hello_imagedev.tif" );

        // Apply a normalization of its graylevels using function coding style
        auto imageNorm = rescaleIntensity( imageInput,
                                           RescaleIntensity::OutputType::SAME_AS_INPUT,
                                           RescaleIntensity::RangeMode::PERCENTILE,
                                           { 2, 98 },
                                           { 0, 255 },
                                           { 0, 255 } );

        // Save the normalized image as a png file
        writeView( imageNorm, "T01_01_norm.png" );

        // Apply a median filter processing using class coding style
        MedianFilter2d processMedian;
        processMedian.setInputImage( imageNorm );
        processMedian.setKernelMode( MedianFilter2d::KernelMode::DISK );
        processMedian.setKernelRadius( 1 );
        processMedian.execute();
        auto imageMedian = processMedian.outputImage();

        // Save the resulting image as a png file
        writeView( processMedian.outputImage(), "T01_01_output.png" );

        std::cout << "This example ran successfully." << std::endl;
    }
    catch ( const imagedev::Exception& error )
    {
        // Print potential exception in the standard output
        std::cerr << "ImageDev exception: " << error.what() << std::endl;
        status = -1;
    }

    // ImageDev library finalization
    imagedev::finish();

    // Check if we must ask for an enter key to close the program
    if ( !( ( argc == 2 ) && strcmp( argv[1], "--no-stop-at-end" ) == 0 ) )
        std::cout << "Press Enter key to close this window." << std::endl, getchar();

    return status;
}
