    // return true if an object is empty, false otherwise
    function isEmptyObject(obj) {
        for(var prop in obj) {
            if(obj.hasOwnProperty(prop))
                return false;
        }
        return true;
    }

   // hide/show class and function div 
   function toggleButton( button_id ) {
        var el = document.getElementById( button_id );
        var w;
        if( button_id == "class_button" ){
            w = document.getElementById( "class_window" );
        }
        else{
            w = document.getElementById( "function_window" );
        }
        if( el.firstChild.data == "-" ){
            el.firstChild.data ="+";
            w.style.display = "none";
        }
        else{
            el.firstChild.data ="-";
            w.style.display = "block";
        }
    }

    // scroll to the last sidenav position
    function init() {
        showLanguage(window.sessionStorage.getItem('lang'));
        sidenav = document.getElementsByClassName("sidenav")[0];
        scrollTop = window.sessionStorage.getItem("scrollTop");
        if (scrollTop) {
            sidenav.scrollTop = Number(scrollTop);
        }
    }

    // DOMContentLoaded occurs before load event
    // when DOM is loaded we run:
    // sidenav initialization: scroll to the previous scroll position if exists
    // code prettify: display code parts with the sunburst style
    window.addEventListener("DOMContentLoaded", init());
    window.addEventListener("DOMContentLoaded", PR.prettyPrint());

    // save the sidenav position when it is scrolled
    function onScrollNav() {
        sidenav = document.getElementsByClassName("sidenav")[0];
        window.sessionStorage.setItem("scrollTop", String(sidenav.scrollTop));
    }

    // display the last langage stored
    function showLanguage(classId) {
        if (classId!='py-show' && classId!='cs-show' && classId!='cpp-show'){
            classId='cpp-show';
        }
        window.sessionStorage.setItem('lang',classId);
        // Declare all variables
        var i, tabcontent, tablinks;

        // Get all elements with class="tabcontent" and hide them
        tabcontent = document.getElementsByClassName("tabcontent");
        for (i = 0; i < tabcontent.length; i++) {
            if (tabcontent[i].classList.contains(classId)) {
                tabcontent[i].style.display = "block";
            } else {
                tabcontent[i].style.display = "none";
            }
        }

        // Get all elements with class="tablinks" and remove the class "active"
        tablinks = document.getElementsByClassName("tablinks");
        for (i = 0; i < tablinks.length; i++) {
            if (tablinks[i].classList.contains(classId)) {
                tablinks[i].className += " active";
            } else {
                tablinks[i].className = tablinks[i].className.replace(" active", "");
            }
        }
    }