# HelloImageDev

from conans import ConanFile, CMake
import os

class HelloImageDevConan(ConanFile):
    settings = "os", "compiler", "arch", "build_type"
    generators = "cmake"

    requires = ("image_dev/2025.1.2@buildsystem/stable",
                "image_dev_data/1.10.12@buildsystem/stable",
                "IOLink/1.11.0@buildsystem/stable",
                "IOFormat/1.8.0@buildsystem/stable")

    def build(self):
        cmake = CMake(self)
        cmake.configure()
        cmake.build()

    def imports(self):
        if self.settings.os == "Windows":
            self.copy(pattern="*.dll", src="lib", dst="%s" % self.settings.build_type)
            self.copy(pattern="*.dll", src="bin", dst="%s" % self.settings.build_type)
            self.copy(pattern="*.pdb", src="bin", dst="%s" % self.settings.build_type)
            self.copy(pattern="*.yml", src="bin", dst="%s" % self.settings.build_type)
        else:
            self.copy(pattern="*.so*", src="lib", dst="%s" % self.settings.build_type)
            self.copy(pattern="*.yml", src="lib", dst="%s" % self.settings.build_type)

