// HelloImageDev

#include <ImageDev/ImageDev.h>
#include <ioformat/IOFormat.h>
#include <iolink/view/ImageViewProvider.h>

using namespace imagedev;
using namespace ioformat;
using namespace iolink;


int main()
{
    // ImageDev library initialization
    imagedev::init();
    
    // Open a tif file
    auto imageInput = ioformat::readImage(std::string( IMAGEDEVDATA_IMAGES_FOLDER ) + "hello_imagedev.tif");
    
    // Apply a normalization of its graylevels using function coding style
    std::shared_ptr<iolink::ImageView> imageNorm =
        rescaleIntensity(imageInput, RescaleIntensity::OutputType::SAME_AS_INPUT,
                         RescaleIntensity::RangeMode::PERCENTILE, { 2, 98 }, { 0, 255 }, { 0, 255 });
    // Save the normalized image as a png file
    ioformat::writeView(imageNorm, R"(hello_imagedev_norm.png)");
    
    // Apply a median filter processing using class coding style
    MedianFilter2d processMedian;
    processMedian.setInputImage(imageNorm);
    processMedian.setKernelMode(MedianFilter2d::KernelMode::DISK);
    processMedian.setKernelRadius(1);
    processMedian.execute();
    auto imageMedian = processMedian.outputImage();
    
    // Save the resulting image as a png file
    ioformat::writeView(processMedian.outputImage(), R"(hello_imagedev_output.png)");
    
    // ImageDev library finalization
    imagedev::finish();
    
    return 0;
}
