using System;
using ImageDev;
using IOLink;

namespace T01_02_InitializeImageDev
{
    class Program
    {
        static void Main( string[] args )
        {
            int status = 0;

            try
            {
                // Initialize the ImageDev library if not done
                if ( Initialization.IsInitialized() == false )
                    Initialization.Init();

                // Generate a random image
                ImageView imageInput = Processing.RandomImage2d( RandomImage2d.OutputType.UNSIGNED_INTEGER_8_BIT, 256, 256, 80.0, 10.0 );
            }
            catch ( Exception error )
            {
                // Print potential exception in the standard output
                System.Console.WriteLine("InitializeImageDev exception: " + error.ToString() );
                status = -1;
            }

            // ImageDev library finalization
            Initialization.Finish();

            // Check if we must ask for an enter key to close the program
            if (!((args.Length >= 1) && (args[0] == "--no-stop-at-end")))
            {
                System.Console.WriteLine("Press Enter key to close this window.");
                System.Console.ReadKey();
            }

            System.Environment.Exit(status);
        }
    }
}
