﻿using System;
using ImageDev;
using IOLink;
using IOFormat;

namespace T04_02_LabelAnalysis
{
    class Program
    {
        static void Main(string[] args)
        {
            int status = 0;

            try
            {
                // ImageDev library initialization
                if (Initialization.IsInitialized() == false)
                    Initialization.Init();

                // Open a binary image from a vip file
                ImageView imageInput = Data.ReadVipImage("Data/images/polystyrene_sep.vip") as ImageView;

                // Connected component labeling of a binary image
                Console.WriteLine("Labeling the binary input...");
                var imageLab = Processing.Labeling2d(imageInput);

                // Define the analysis features to be computed
                Console.WriteLine("Performing the label analysis...");
                AnalysisMsr analysis = new AnalysisMsr();
                var diameter = analysis.Select(NativeMeasurements.EquivalentDiameter);
                var feretRatio = analysis.Select(NativeMeasurements.FeretRatio2d);

                // Launch the feature extraction on the segmented image
                Processing.LabelAnalysis(imageLab, imageInput, analysis);
                int labelCount = analysis.LabelCount();
                Console.WriteLine("  - Number of objects = " + labelCount);
                Console.WriteLine("Label\t" + diameter.Name() + "\t" + feretRatio.Name());
                // Print the 4 first results of the analysis
                for (int i = 0; i < 4; i++)
                {
                    Console.WriteLine((i + 1) + "\t" + diameter.Value(i).ToString("0.00") + "\t\t\t" +
                                       feretRatio.Value(i).ToString("0.00"));
                }

                // Notify the garbage collector that the created images can be freed
                imageInput.Dispose();
                imageLab.Dispose();

            }
            catch (Exception error)
            {
                // Print potential exception in the standard output
                System.Console.WriteLine("HelloImageDev exception: " + error.ToString());
                status = -1;
            }

            // ImageDev library finalization
            Initialization.Finish();

            // Check if we must ask for an enter key to close the program
            if (!((args.Length >= 1) && (args[0] == "--no-stop-at-end")))
            {
                System.Console.WriteLine("Press Enter key to close this window.");
                System.Console.ReadKey();
            }

            System.Environment.Exit(status);
        }
    }
}
