using System;
using ImageDev;
using IOLink;
using IOFormat;

namespace T01_01_HelloImageDev
{
    class Program
    {
        static void Main( string[] args )
        {
            int status = 0;

            try
            {
                // Initialize the ImageDev library if not done
                if ( Initialization.IsInitialized() == false )
                    Initialization.Init();

                // Open a tif file
                ImageView imageInput = ViewIO.ReadImage( "Data/images/hello_imagedev.tif" );

                // Apply a normalization of its graylevels using function coding style
                ImageView imageNorm = Processing.RescaleIntensity( imageInput,
                                                                   RescaleIntensity.OutputType.SAME_AS_INPUT,
                                                                   RescaleIntensity.RangeMode.PERCENTILE,
                                                                   new double[] { 2, 98 },
                                                                   new double[] { 0, 255 },
                                                                   new double[] { 10, 255 } );
                ViewIO.WriteView( imageNorm, "T01_01_norm.png" );

                // Apply a median filter processing using class coding style
                MedianFilter2d processMedian = new MedianFilter2d {
                    inputImage = imageNorm,
                    kernelMode = MedianFilter2d.KernelMode.DISK,
                    kernelRadius = 1,
                };
                processMedian.Execute();
                var imageMedian = processMedian.outputImage;

                // Notify the garbage collector that the intermediate image can be freed
                imageNorm.Dispose();

                // Save the resulting image as a png file
                ViewIO.WriteView( imageMedian, "T01_01_output.png" );

            }
            catch ( Exception error )
            {
                // Print potential exception in the standard output
                System.Console.WriteLine("HelloImageDev exception: " + error.ToString() );
                status = -1;
            }

            // ImageDev library finalization
            Initialization.Finish();

            // Check if we must ask for an enter key to close the program
            if (!((args.Length >= 1) && (args[0] == "--no-stop-at-end")))
            {
                System.Console.WriteLine("Press Enter key to close this window.");
                System.Console.ReadKey();
            }

            System.Environment.Exit(status);
        }
    }
}
