﻿using System;
using ImageDev;
using IOLink;
using IOFormat;

namespace T03_01_Denoising
{
    class Program
    {
        static void Main(string[] args)
        {
            int status = 0;

            try
            {
                // Initialize the ImageDev library if not done
                if (Initialization.IsInitialized() == false)
                    Initialization.Init();

                // Open a tif file to denoise
                ImageView imageInput = ViewIO.ReadImage("Data/images/mnu.tif") as ImageView;

                // Apply an average filter
                Console.WriteLine("Applying a box filter...");
                ImageView imageOutput = Processing.BoxFilter2d(imageInput, 7, 7) as ImageView;
                IOFormat.ViewIO.WriteView(imageOutput, "T03_01_box.png");

                // Apply a median filter processing
                Console.WriteLine("Applying a median filter... ");
                imageOutput = Processing.MedianFilter2d(imageInput, 3, MedianFilter2d.KernelMode.SQUARE);
                IOFormat.ViewIO.WriteView(imageOutput, "T03_01_median.png");

                // Apply a non-local means filter processing
                Console.WriteLine("Applying a non-local means filter... ");
                imageOutput = Processing.NonLocalMeansFilter2d(imageInput, 3, 3);
                IOFormat.ViewIO.WriteView(imageOutput, "T03_01_nlm.png");

            }
            catch (Exception error)
            {
                // Print potential exception in the standard output
                System.Console.WriteLine("HelloImageDev exception: " + error.ToString());
                status = -1;
            }

            // ImageDev library finalization
            Initialization.Finish();

            // Check if we must ask for an enter key to close the program
            if (!((args.Length >= 1) && (args[0] == "--no-stop-at-end")))
            {
                System.Console.WriteLine("Press Enter key to close this window.");
                System.Console.ReadKey();
            }

            System.Environment.Exit(status);
        }
    }
}
