﻿using System;
using ImageDev;
using IOLink;
using IOFormat;

namespace T05_01_AlgorithmTracking
{
    class Program
    {
        // Callback that displays the progression percentage
        static void progressionCallback(object algorithm, float ratio)
        {
            Console.WriteLine(algorithm.ToString() + " - Progression: " + (100.0 * ratio).ToString("0.00") + "%");
        }

        // Callback that displays the algorithm information
        static void informationCallback(object algorithm, string message)
        {
            Console.WriteLine(algorithm.ToString() + " - Information: " + message);
        }

        static void Main(string[] args)
        {
            int status = 0;

            try
            {
                // ImageDev library initialization
                if (Initialization.IsInitialized() == false)
                    Initialization.Init();

                // Open a 3D Amira Mesh file
                ImageView imageInput = ViewIO.ReadImage("Data/images/shale.am") as ImageView;

                // Enable a callback for indicating the algorithm progression
                Processing.SetProgressRatioCallback(progressionCallback);

                // Apply a closing filter
                var imageOutput = Processing.Closing3d(imageInput, 50);

                // Disable the progression callback
                Processing.SetProgressRatioCallback(null);

                // Enable a callback for indicating the algorithm information
                Processing.SetProgressMessageCallback(informationCallback);

                // Apply a closing by reconstruction filter
                imageOutput = Processing.ClosingByReconstruction3d(imageInput, 20);

                // Disable the information callback
                Processing.SetProgressMessageCallback(null);

                // Enable the verbose mode that indicates the duration of each algorithm
                Processing.SetVerbose(true);

                // Apply a median filter
                imageOutput = Processing.MedianFilter3d(imageInput, 5);

                // Disable the verbose mode
                Processing.SetVerbose(false);

            }
            catch (Exception error)
            {
                // Print potential exception in the standard output
                System.Console.WriteLine("HelloImageDev exception: " + error.ToString());
                status = -1;
            }

            // ImageDev library finalization
            Initialization.Finish();

            // Check if we must ask for an enter key to close the program
            if (!((args.Length >= 1) && (args[0] == "--no-stop-at-end")))
            {
                System.Console.WriteLine("Press Enter key to close this window.");
                System.Console.ReadKey();
            }

            System.Environment.Exit(status);
        }
    }
}
