import imagedev
import imagedev_data
import ioformat

try:
  # Open and display a tif file
  image_input = ioformat.read_image(imagedev_data.get_image_path("hello_imagedev.tif"))
  #imagedev.imshow(image_input, False)

  # Apply a normalization of its graylevels using function coding style
  image_norm = imagedev.rescale_intensity(image_input, range_mode=imagedev.RescaleIntensity.RangeMode.PERCENTILE)

  # Display and save the normalized image as a png file
  #imagedev.imshow(image_norm, False)
  ioformat.write_view(image_norm, "T01_01_norm.png")

  # Apply a median filter processing using class coding style
  process_median = imagedev.MedianFilter2d()
  process_median.input_image = image_norm
  process_median.kernel_mode = imagedev.MedianFilter2d.KernelMode.DISK
  process_median.kernel_radius = 1
  process_median.execute()
  im_median = process_median.output_image

  # Display and save the resulting image as a png file
  #imagedev.imshow(im_median)
  ioformat.write_view(im_median, "T01_01_output.png")

except Exception as error:
  # Print potential exception in the standard output
  print("HelloImageDev exception: " + str(error))