import imagedev
import iolink
import ioformat
import numpy

# Initialize an unsigned 8-bit three-dimensional numpy array storing data of a 3D image
row_count = 220
col_count = 192
sli_count = 128
image_data = numpy.zeros((sli_count, row_count, col_count), numpy.uint8)

# Define a synthetic sphere in this array
# Define the sphere center and radius value
center = (int(sli_count/2), int(row_count/2), int(col_count/2))
radius = int(sli_count/2) - 10

# Create a distance map image with origin the sphere center
slice_grid, row_grid, col_grid = numpy.ogrid[:sli_count, :row_count, :col_count]
dist_from_center = numpy.sqrt((slice_grid - center[0])**2 + (row_grid-center[1])**2 + (col_grid-center[2])**2)

# Mask the distance map where values are greater than the radius value
mask = dist_from_center <= radius
image_data[mask] = 200

# Transform the Numpy array into an ImageView of same dimensions and type
image = iolink.NumpyInterop.from_numpy_array(image_data, iolink.ImageTypeId.VOLUME)

# This image can now be processed by any ImageDev algorithm, for instance to add a Gaussian noise inside
image_noise = imagedev.random_gaussian_image_3d(
  imagedev.RandomGaussianImage3d.OutputType.SIGNED_INTEGER_8_BIT, col_count, row_count, sli_count, 0.0, 20.0)
image_out = imagedev.arithmetic_operation_with_image(
  image, image_noise, imagedev.ArithmeticOperationWithImage.ArithmeticOperator.ADD)

# Save the created image with IOFormat
ioformat.write_view(image_out, "T02_03_output.tif")