import imagedev
import imagedev_data
import ioformat

# Open a tif file to denoise
image_input = ioformat.read_image(imagedev_data.get_image_path("mnu.tif"))

# Apply an average filter
print("Applying a box filter...")
image_output = imagedev.box_filter_2d(image_input, 7, 7)
ioformat.write_view(image_output, "T03_01_box.png")

# Apply a median filter processing
print("Applying a median filter...")
image_output = imagedev.median_filter_2d(image_input, 3, imagedev.MedianFilter2d.SQUARE)
ioformat.write_view(image_output, "T03_01_median.png")

# Apply a non-local means filter processing
print("Applying a non-local means filter...")
image_output = imagedev.non_local_means_filter_2d(image_input, 3, 3)
ioformat.write_view(image_output, "T03_01_nlm.png")