import imagedev
import imagedev_data
import ioformat

# Open a tif file to analyze
image_input = ioformat.read_image(imagedev_data.get_image_path("micro_nucleus.tif"))

# Extract intensity statistics from an RGB image
print("Computing color intensity statistics... ")
statistics = imagedev.intensity_statistics(image_input)
print("  - Average intensity [R, G, B] = [" + "{:.2f}".format(statistics.mean(0, 0)) + ", " +
			"{:.2f}".format(statistics.mean(1, 0)) + ", " +
			"{:.2f}".format(statistics.mean(2, 0))  + "]")
print("  - Standard Deviation = [R, G, B] = [" +
			"{:.2f}".format(statistics.standard_deviation(0, 0)) + ", " +
			"{:.2f}".format(statistics.standard_deviation(1, 0)) + ", " +
			"{:.2f}".format(statistics.standard_deviation(2, 0)) + "]")
print("  - Red intensity range = [" + str(statistics.minimum(0, 0)) + ", " + str(statistics.maximum(0, 0)) + "]")
print("  - Green intensity range = [" + str(statistics.minimum(1, 0)) + ", " + str(statistics.maximum(1, 0)) + "]")
print("  - Blue intensity range = [" + str(statistics.minimum(2, 0)) + ", " + str(statistics.maximum(2, 0)) + "]")

# Threshold image pixels having an intensity lower than 190 in each RGB channel
print("Color thresholding and binary analysis... ")
image_output = imagedev.color_thresholding( image_input, [0, 190], [0, 190], [0, 190])

# Measure the object area
area = imagedev.area_2d(image_output)
print("  - Total area of detected objects = " + str(area.area(0)))
print("  - Phase fraction of detected objects = " + "{:.2f}".format(100.0 * area.area_fraction(0)) + " %")

# Count the number of detected objects
count = imagedev.object_count(image_output)
print("  - Number of detected objects = " + str(count[1].count(0)))
# Rescale binary the image intensities between 0 and 255 for visualization and save it
image_output = imagedev.rescale_intensity(image_output, imagedev.RescaleIntensity.UNSIGNED_INTEGER_8_BIT)
ioformat.write_view(image_output, "T04_01_output.png")