import imagedev
import imagedev_data

# Open a binary image from a vip file
image_input = imagedev.read_vip_image(imagedev_data.get_image_path("polystyrene_sep.vip"))

# Connected component labeling of the binary image
print("Labeling the binary input...")
image_lab = imagedev.labeling_2d(image_input, imagedev.Labeling2d.LabelType.LABEL_8_BIT)

# Define the analysis features to be computed
print("Performing the label analysis...")
analysis = imagedev.AnalysisMsr()
diameter = analysis.select(imagedev.native_measurements.EquivalentDiameter)
feret_ratio = analysis.select(imagedev.native_measurements.FeretRatio2d)

# Launch the feature extraction on the segmented image
imagedev.label_analysis(image_lab, image_input, analysis)
label_count = analysis.label_count
print("  - Number of objects = " + str(label_count))
# Print the 4 first results of the analysis
print("Label\t" + diameter.name + "\t" + feret_ratio.name)
for i in range(3):
  print(str(i+1) + '\t\t\t' + "{:.2f}".format(diameter.value(i)) + '\t\t\t\t' + "{:.2f}".format(feret_ratio.value(i)))