import imagedev
import imagedev_data
import ioformat

# Open and display a tif file
image_input = ioformat.read_image(imagedev_data.get_image_path("polystyrene.tif"))

# Threshold the grayscale image
image_thr = imagedev.thresholding_by_criterion(\
  image_input, imagedev.ThresholdingByCriterion.ComparisonCriterion.GREATER_THAN, 128)

# Separate connected particles
image_sep = imagedev.separate_objects(image_thr, 2)
image_thr = None

# Remove particles touching image borders
image_bdk = imagedev.kill_border_2d(image_sep)
image_sep = None

# Connected component labeling of a binary image
image_lab = imagedev.labeling_2d(\
  image_bdk, imagedev.Labeling2d.LabelType.LABEL_8_BIT, imagedev.Labeling2d.Neighborhood.CONNECTIVITY_8)

# The number of particles is the maximum label
extrema = imagedev.intensity_extrema(image_lab, 0)
particle_count = int(extrema.maximum(0, 0, 0))

# Define the analysis features to be computed
analysis = imagedev.AnalysisMsr()
center_x = analysis.select(imagedev.native_measurements.BarycenterX)
center_y = analysis.select(imagedev.native_measurements.BarycenterY)
diameter = analysis.select(imagedev.native_measurements.EquivalentDiameter)
intensity = analysis.select(imagedev.native_measurements.IntensityMean)

# Launch the feature extraction on the segmented image
imagedev.label_analysis(image_lab, image_input, analysis)
print("Number of particles = " + str(particle_count))
print("Particle\t" + center_x.name + "\t" + center_y.name + "\t" + diameter.name + "\t" + intensity.name)
# Print the analysis results for 10% of the particles
for i in range(int(particle_count/10)):
  print(str(i+1) + '\t\t\t' + "{:.2f}".format(center_x.value(i)) +'\t\t' + "{:.2f}".format(center_y.value(i)) +\
    '\t\t' + "{:.2f}".format(diameter.value(i)) + '\t\t\t\t' + "{:.2f}".format(intensity.value(i)))

# Save the created image with IOFormat
ioformat.write_view(image_lab, "T06_01_output.png")