import imagedev
import iolink
import ioformat
import numpy

# Initialize an unsigned 8 - bit array storing data of a 3D image
row_count = 768
col_count = 1024
image_data = numpy.zeros((row_count , col_count), numpy.uint8)
# Define a synthetic square in this array
side = int(col_count / 2) # side in pixels of the square to draw

image_data[int((row_count - side) / 2):int((row_count + side) / 2),
           int((col_count - side) / 2):int((col_count + side) / 2)] = 228

# Create an image view of same dimensions VectorXu64
image_shape = iolink.VectorXu64(col_count, row_count)
image = iolink.ImageViewFactory.allocate(image_shape, iolink.DataTypeId_UINT8)
image.axes_interpretation = iolink.ImageTypeId.IMAGE

# Define the region where to write the data
image_orig = iolink.VectorXu64(0, 0)
image_region = iolink.RegionXu64(image_orig, image_shape)

# Copy the data in the image view
image.write_region(image_region, image_data)

# This image can now be processed by any ImageDev algorithm, for instance for building a color image
image_void = imagedev.reset_image(image, 0.0)
image_rgb = imagedev.grayscale_to_color(image, image, image_void)

# Save the created image with IOFormat
ioformat.write_view(image_rgb, "T02_01_output.png")