import imagedev
import imagedev_data
import ioformat

# Open a tif file to binarize
image_input = ioformat.read_image(imagedev_data.get_image_path("objects.tif"))

# Threshold image pixels having an intensity between 60 and 255
print("Thresholding between a minimum and maximum value...")
image_output = imagedev.thresholding(image_input,  [ 60, 255 ])
# Rescale the binary image intensities between 0 and 255 for visualization and save it
image_output = imagedev.rescale_intensity(image_output, imagedev.RescaleIntensity.UNSIGNED_INTEGER_8_BIT)
ioformat.write_view(image_output, "T03_02_manual.png")

# Threshold image pixels having an intensity greater than 40
print("Thresholding by comparison to a value...")
image_output = imagedev.thresholding_by_criterion(image_input, comparison_value = 40)
# Rescale the binary image intensities between 0 and 255 for visualization and save it
image_output = imagedev.rescale_intensity(image_output, imagedev.RescaleIntensity.UNSIGNED_INTEGER_8_BIT)
ioformat.write_view(image_output, "T03_02_criterion.png")

# Threshold image pixels automatically with Otsu's method
print("Automatic thresholding with Otsu method...")
result = imagedev.auto_thresholding_bright(image_input, threshold_criterion=imagedev.AutoThresholdingBright.FACTORISATION)
# Rescale the binary image intensities between 0 and 255 for visualization and save it
image_output = imagedev.rescale_intensity(result[0], imagedev.RescaleIntensity.UNSIGNED_INTEGER_8_BIT)
ioformat.write_view(image_output, "T03_02_auto.png")