import imagedev
import imagedev_data
import ioformat

try:
    # Open a grayscale image from a tif file
    image_input = ioformat.read_image(imagedev_data.get_image_path('objects.tif'))

    # Threshold and label the binary input
    image_bin = imagedev.thresholding_by_criterion(image_input, comparison_value=40)
    image_lab = imagedev.labeling_2d(image_bin, imagedev.Labeling2d.LabelType.LABEL_8_BIT)

    # Create a group of measurements
    group = imagedev.MeasurementGroup()
    group.add(imagedev.native_measurements.InverseCircularity2d)
    group.add(imagedev.native_measurements.FeretDiameter2d)

    # Save this group and reload it
    group.write('T04_04_group.xml')
    saved_group = imagedev.MeasurementGroup()
    saved_group.read('T04_04_group.xml')

    # Define an analysis with the features of the group
    analysis = imagedev.AnalysisMsr()
    analysis.select(saved_group)

    # Launch the feature extraction on the segmented image
    imagedev.label_analysis(image_lab, image_input, analysis)

    # Print the analysis in the standard output
    print(analysis.to_data_frame())

    print("This example ran successfully.")
except Exception as error:
    # Print potential exception in the standard output
    print("T04_04_MeasurementGroup exception: " + str(error))
