import imagedev
import imagedev_data
import ioformat

try:
    # Open a grayscale image from a tif file
    image_input = ioformat.read_image(imagedev_data.get_image_path('objects.tif'))

    # Threshold and label the binary input
    image_bin = imagedev.thresholding_by_criterion(image_input, comparison_value=40)
    image_lab = imagedev.labeling_2d(image_bin, imagedev.Labeling2d.LabelType.LABEL_8_BIT)

    # Change the number of Feret diameter to 2 (0 and 90 degrees)
    imagedev.MeasurementAttributes.feret2d.orientation_count = 2
    imagedev.MeasurementAttributes.feret2d.resample()
    print(f'FeretDiameter[0] = {imagedev.MeasurementAttributes.feret2d.orientation(0)}')
    print(f'FeretDiameter[1] = {imagedev.MeasurementAttributes.feret2d.orientation(1)}')

    # Create a circularity factor between 0 and 1
    my_formula = '4*Pi*' + imagedev.native_measurements.Area2d.name + '/' + \
                 imagedev.native_measurements.PolygonePerimeter2d.name + '**2'

    if not imagedev.check_measurement_formula(my_formula):
        # Raise an exception if the formula is not valid
        raise Exception('Invalid formula ' + my_formula)

    my_circularity = imagedev.AnalysisMsr.register_custom_measurement('MyCircularity', my_formula,
                                                                      'A circularity factor between 0 and 1.',
                                                                      imagedev.PhysicalDimension.RATIO)
    # Define the analysis features to be computed
    analysis = imagedev.AnalysisMsr()
    analysis.select(imagedev.native_measurements.FeretDiameter2d)
    analysis.select(my_circularity)

    # Launch the feature extraction on the segmented image
    imagedev.label_analysis(image_lab, image_input, analysis)

    # Print the analysis in the standard output
    print(analysis.to_data_frame())

    print("This example ran successfully.")
except Exception as error:
    # Print potential exception in the standard output
    print("T04_05_CustomAnalysis exception: " + str(error))
