import imagedev
import imagedev_data
import ioformat

#  Callback that displays the progression percentage
def progression_callback(algorithm, ratio):
  progress = ratio
  print( " - Progression: " + "{:.2f}".format( 100.0 * ratio) + "%" )

# Callback that displays the algorithm information
def information_callback(algorithm, message):
  print(" - Information: " + message )

# Open a 3D Amira Mesh file
image_input = ioformat.read_image(imagedev_data.get_image_path("shale.am"))

# Enable a callback for indicating the algorithm progression
imagedev.set_progress_ratio_callback(progression_callback)

# Apply a closing filter
imageOutput = imagedev.closing_3d(image_input, 50)

# Disable the progression callback
imagedev.set_progress_ratio_callback(None)

# Enable a callback for indicating the algorithm information
imagedev.set_progress_message_callback(information_callback)

# Apply a closing by reconstruction filter
imageOutput = imagedev.closing_by_reconstruction_3d(image_input, 20)

# Disable the information callback
imagedev.set_progress_message_callback(None)

# Enable the verbose mode that indicates the duration of each algorithm
imagedev.set_verbose(True)

# Apply a median filter
imageOutput = imagedev.median_filter_3d(image_input, 5)

# Disable the verbose mode
imagedev.set_verbose(False)