/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.ldm.readers;

import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.IntegerValuedEnumHelper;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SbBox2i32;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbBox3i32;
import com.openinventor.inventor.SbVec2d;
import com.openinventor.inventor.SbVec3i32;
import com.openinventor.inventor.devices.SoBufferObject;
import com.openinventor.inventor.devices.SoCpuBufferObject;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.ldm.internal.JarInitializer;
import com.openinventor.ldm.internal.JniInitializer;
import com.openinventor.ldm.nodes.SoDataSet;
import com.openinventor.ldm.writers.SoVolumeWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class SoVolumeReader
extends SoFieldContainer {
    private boolean customVolumeReader = false;

    private static native long ctorImpl();

    protected SoVolumeReader() {
        this(Inventor.ConstructorCommand.CreateInstance, SoVolumeReader.ctorImpl());
        this.customVolumeReader = true;
    }

    private void onGetDataChar() {
        if (this.customVolumeReader) {
            throw new UnsupportedOperationException("Method must be reimplemented.");
        }
    }

    private void onGetSubSlice() {
        if (this.customVolumeReader) {
            throw new UnsupportedOperationException("Method must be reimplemented.");
        }
    }

    private static void notifyGetSubSlice(long l, ByteBuffer byteBuffer, int n, long l2) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        SbBox2i32 sbBox2i32 = new SbBox2i32();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().get(sbBox2i32.array);
        SoBufferObject soBufferObject = (SoBufferObject)ObjectManager.getManagedObjectFor(SoBufferObject.class, (Long)l2);
        try {
            soVolumeReader.getSubSlice(sbBox2i32, n, soBufferObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int notifyGetDataChar(long l, ByteBuffer byteBuffer, int[] nArray, ByteBuffer byteBuffer2) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer2.order(ByteOrder.nativeOrder());
            DataInfo dataInfo = soVolumeReader.getDataChar();
            byteBuffer.asFloatBuffer().put(dataInfo.size.array);
            nArray[0] = dataInfo.type.getValue();
            byteBuffer2.asIntBuffer().put(dataInfo.dim.array);
            return dataInfo.readError.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return ReadErrors.RD_UNKNOWN_ERROR.getValue();
        }
    }

    private static int notifyGetNumSignificantBits(long l) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            return soVolumeReader.getNumSignificantBits();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    private static boolean notifyIsDataConverted(long l) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            return soVolumeReader.isDataConverted();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static long notifyReadTile(long l, int n, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        SbBox3i32 sbBox3i32 = new SbBox3i32();
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.asIntBuffer().get(sbBox3i32.array);
        try {
            SoBufferObject soBufferObject = soVolumeReader.readTile(n, sbBox3i32);
            if (soBufferObject == null) {
                return 0L;
            }
            return soBufferObject.getNativeResourceHandle();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    private static boolean notifyGetTileSize(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            SbVec3i32 sbVec3i32 = soVolumeReader.getTileSize();
            if (sbVec3i32 == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asIntBuffer().put(sbVec3i32.array);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static void notifyGetTileMinMax(long l, ByteBuffer byteBuffer, int n) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            SbVec2d sbVec2d = soVolumeReader.getTileMinMax(n);
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asDoubleBuffer().put(sbVec2d.array);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static boolean notifyGetMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            long[] lArray = soVolumeReader.getMinMax();
            if (lArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asLongBuffer().put(lArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyGetIntMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            int[] nArray = soVolumeReader.getIntMinMax();
            if (nArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asIntBuffer().put(nArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyGetDoubleMinMax(long l, ByteBuffer byteBuffer) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            double[] dArray = soVolumeReader.getDoubleMinMax();
            if (dArray == null) {
                return false;
            }
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.asDoubleBuffer().put(dArray);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyIsThreadSafe(long l) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            return soVolumeReader.isThreadSafe();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static boolean notifyIsRGBA(long l) {
        SoVolumeReader soVolumeReader = (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)l);
        try {
            return soVolumeReader.isRGBA();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static native void restoreAllHandlesImpl(long var0);

    private static native void setRGBAImpl(long var0, boolean var2);

    private static native void closeAllHandlesImpl(long var0);

    private static native boolean getTileSizeImpl(long var0, int[] var2);

    private static native boolean getIntMinMaxImpl(long var0, int[] var2, int[] var3);

    private static native void reloadTileMinMaxImpl(long var0);

    private static native int getBorderFlagImpl(long var0);

    private static native boolean readTileImpl2(long var0, int var2, long var3, int[] var5);

    private static native long readTileImpl(long var0, int var2, int[] var3);

    private static native boolean isThreadSafeImpl(long var0);

    private static native int getReaderTypeImpl(long var0);

    private static native long getConfiguredWriterImpl(long var0);

    private static native boolean getDoubleMinMaxImpl(long var0, double[] var2, double[] var3);

    private static native boolean setDirectCoordSysAutoDetectionImpl(long var0, boolean var2);

    private static native boolean setDirectCoorSysImpl(long var0, boolean var2);

    private static native boolean getDirectCoordSysImpl(long var0);

    private static native boolean getDirectCoordSysAutoDetectionImpl(long var0);

    private static native void setRectilinearCoordinatesImpl(long var0, float[] var2, float[] var3, float[] var4);

    private static native boolean isIgnoredFileImpl(long var0);

    private static native boolean isRGBAImpl(long var0);

    private static native String getOriginalFilenameImpl(long var0);

    private static native int getCoordinateTypeImpl(long var0);

    private static native boolean getMinMaxImpl(long var0, long[] var2, long[] var3);

    private static native long getAppropriateReaderImpl(String var0);

    private static native void getSubSliceImpl1(long var0, int[] var2, int var3, long var4);

    private static native int getDataCharImpl(long var0, float[] var2, int[] var3, int[] var4);

    private static native boolean setOutputDataTypeImpl(long var0, boolean var2, int var3);

    private static native boolean setInputDataRangeImpl(long var0, boolean var2, double var3, double var5);

    private static native int getNumSignificantBitsImpl(long var0);

    private static native String getFilenameImpl(long var0);

    private static native void getTileMinMaxImpl(long var0, int var2, double[] var3);

    private static native boolean isDataConvertedImpl(long var0);

    private static native int setFilenameImpl(long var0, String var2);

    private static native void getNumVoxelsImpl(long var0, int[] var2, int[] var3, int[] var4);

    private static native void getSizeToAllocateImpl(long var0, int[] var2, int[] var3, int[] var4);

    protected SoVolumeReader(Inventor.ConstructorCommand constructorCommand, long l) {
        super(constructorCommand, l);
        this.initializeFields();
    }

    static native String getClassTypeId();

    public boolean isDataConverted() {
        if (this.customVolumeReader) {
            return false;
        }
        return SoVolumeReader.isDataConvertedImpl(this.getNativeResourceHandle());
    }

    public void reloadTileMinMax() {
        SoVolumeReader.reloadTileMinMaxImpl(this.getNativeResourceHandle());
    }

    public String getFilename() {
        return SoVolumeReader.getFilenameImpl(this.getNativeResourceHandle());
    }

    public int setFilename(String string) {
        return SoVolumeReader.setFilenameImpl(this.getNativeResourceHandle(), string);
    }

    public boolean setDirectCoorSys(boolean bl) {
        return SoVolumeReader.setDirectCoorSysImpl(this.getNativeResourceHandle(), bl);
    }

    public ReaderTypes getReaderType() {
        return (ReaderTypes)IntegerValuedEnumHelper.fromIntValue(ReaderTypes.class, (int)SoVolumeReader.getReaderTypeImpl(this.getNativeResourceHandle()));
    }

    public boolean setDirectCoordSysAutoDetection(boolean bl) {
        return SoVolumeReader.setDirectCoordSysAutoDetectionImpl(this.getNativeResourceHandle(), bl);
    }

    public SbVec2d getTileMinMax(int n) {
        if (this.customVolumeReader) {
            return new SbVec2d(Double.MAX_VALUE, -1.7976931348623157E308);
        }
        SbVec2d sbVec2d = new SbVec2d();
        SoVolumeReader.getTileMinMaxImpl(this.getNativeResourceHandle(), n, sbVec2d.array);
        return sbVec2d;
    }

    public boolean getDirectCoordSysAutoDetection() {
        return SoVolumeReader.getDirectCoordSysAutoDetectionImpl(this.getNativeResourceHandle());
    }

    public SbVec3i32 getSizeToAllocate(SbVec3i32 sbVec3i32, SbVec3i32 sbVec3i322) {
        SbVec3i32 sbVec3i323 = new SbVec3i32();
        SoVolumeReader.getSizeToAllocateImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbVec3i322 != null ? sbVec3i322.array : null, sbVec3i323.array);
        return sbVec3i323;
    }

    public DataInfo getDataChar() {
        this.onGetDataChar();
        DataInfo dataInfo = new DataInfo();
        SbBox3f sbBox3f = new SbBox3f();
        int[] nArray = new int[1];
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        dataInfo.readError = (ReadErrors)IntegerValuedEnumHelper.fromIntValue(ReadErrors.class, (int)SoVolumeReader.getDataCharImpl(this.getNativeResourceHandle(), sbBox3f != null ? sbBox3f.array : null, nArray, sbVec3i32 != null ? sbVec3i32.array : null));
        dataInfo.size = sbBox3f;
        dataInfo.type = (SoDataSet.DataTypes)IntegerValuedEnumHelper.fromIntValue(SoDataSet.DataTypes.class, (int)nArray[0]);
        dataInfo.dim = sbVec3i32;
        return dataInfo;
    }

    public boolean setOutputDataType(boolean bl, SoDataSet.DataTypes dataTypes) {
        return SoVolumeReader.setOutputDataTypeImpl(this.getNativeResourceHandle(), bl, dataTypes.getValue());
    }

    public boolean getDirectCoordSys() {
        return SoVolumeReader.getDirectCoordSysImpl(this.getNativeResourceHandle());
    }

    public static SoVolumeReader getAppropriateReader(String string) {
        return (SoVolumeReader)ObjectManager.getManagedObjectFor(SoVolumeReader.class, (Long)SoVolumeReader.getAppropriateReaderImpl(string));
    }

    public boolean setInputDataRange(boolean bl, double d, double d2) {
        return SoVolumeReader.setInputDataRangeImpl(this.getNativeResourceHandle(), bl, d, d2);
    }

    public void getSubSlice(SbBox2i32 sbBox2i32, int n, SoBufferObject soBufferObject) {
        this.onGetSubSlice();
        SoVolumeReader.getSubSliceImpl1(this.getNativeResourceHandle(), sbBox2i32 != null ? sbBox2i32.array : null, n, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle);
    }

    public SbVec3i32 getNumVoxels(SbVec3i32 sbVec3i32, SbVec3i32 sbVec3i322) {
        SbVec3i32 sbVec3i323 = new SbVec3i32();
        SoVolumeReader.getNumVoxelsImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null, sbVec3i322 != null ? sbVec3i322.array : null, sbVec3i323.array);
        return sbVec3i323;
    }

    public int getNumSignificantBits() {
        if (this.customVolumeReader) {
            return 0;
        }
        return SoVolumeReader.getNumSignificantBitsImpl(this.getNativeResourceHandle());
    }

    public SoVolumeWriter getConfiguredWriter() {
        return (SoVolumeWriter)ObjectManager.getManagedObjectFor(SoVolumeWriter.class, (Long)SoVolumeReader.getConfiguredWriterImpl(this.getNativeResourceHandle()));
    }

    public SbVec3i32 getTileSize() {
        if (this.customVolumeReader) {
            return null;
        }
        SbVec3i32 sbVec3i32 = new SbVec3i32();
        boolean bl = false;
        bl = SoVolumeReader.getTileSizeImpl(this.getNativeResourceHandle(), sbVec3i32 != null ? sbVec3i32.array : null);
        if (bl) {
            return sbVec3i32;
        }
        return null;
    }

    @Deprecated(since="9.5.0.0")
    public int[] getIntMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl = false;
        bl = SoVolumeReader.getIntMinMaxImpl(this.getNativeResourceHandle(), nArray, nArray2);
        if (bl) {
            int[] nArray3 = new int[]{nArray[0], nArray2[0]};
            return nArray3;
        }
        return null;
    }

    public void restoreAllHandles() {
        SoVolumeReader.restoreAllHandlesImpl(this.getNativeResourceHandle());
    }

    public void closeAllHandles() {
        SoVolumeReader.closeAllHandlesImpl(this.getNativeResourceHandle());
    }

    public SoBufferObject readTile(int n, SbBox3i32 sbBox3i32) {
        if (this.customVolumeReader) {
            return new SoCpuBufferObject();
        }
        return (SoBufferObject)ObjectManager.getManagedObjectFor(SoBufferObject.class, (Long)SoVolumeReader.readTileImpl(this.getNativeResourceHandle(), n, sbBox3i32 != null ? sbBox3i32.array : null));
    }

    @Deprecated(since="8.5.0.0")
    public boolean readTile(int n, SoBufferObject soBufferObject, SbBox3i32 sbBox3i32) {
        return SoVolumeReader.readTileImpl2(this.getNativeResourceHandle(), n, soBufferObject != null ? soBufferObject.getNativeResourceHandle() : Inventor.ZeroHandle, sbBox3i32 != null ? sbBox3i32.array : null);
    }

    @Deprecated(since="9.0.0.0")
    public int getBorderFlag() {
        return SoVolumeReader.getBorderFlagImpl(this.getNativeResourceHandle());
    }

    public long[] getMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        long[] lArray = new long[1];
        long[] lArray2 = new long[1];
        boolean bl = false;
        bl = SoVolumeReader.getMinMaxImpl(this.getNativeResourceHandle(), lArray, lArray2);
        if (bl) {
            long[] lArray3 = new long[]{lArray[0], lArray2[0]};
            return lArray3;
        }
        return null;
    }

    public double[] getDoubleMinMax() {
        if (this.customVolumeReader) {
            return null;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        boolean bl = false;
        bl = SoVolumeReader.getDoubleMinMaxImpl(this.getNativeResourceHandle(), dArray, dArray2);
        if (bl) {
            double[] dArray3 = new double[]{dArray[0], dArray2[0]};
            return dArray3;
        }
        return null;
    }

    public CoordinateTypes getCoordinateType() {
        return (CoordinateTypes)IntegerValuedEnumHelper.fromIntValue(CoordinateTypes.class, (int)SoVolumeReader.getCoordinateTypeImpl(this.getNativeResourceHandle()));
    }

    public void setRectilinearCoordinates(float[] fArray, float[] fArray2, float[] fArray3) {
        SoVolumeReader.setRectilinearCoordinatesImpl(this.getNativeResourceHandle(), fArray, fArray2, fArray3);
    }

    public void setRGBA(boolean bl) {
        SoVolumeReader.setRGBAImpl(this.getNativeResourceHandle(), bl);
    }

    public boolean isThreadSafe() {
        if (this.customVolumeReader) {
            return false;
        }
        return SoVolumeReader.isThreadSafeImpl(this.getNativeResourceHandle());
    }

    public boolean isIgnoredFile() {
        return SoVolumeReader.isIgnoredFileImpl(this.getNativeResourceHandle());
    }

    public String getOriginalFilename() {
        return SoVolumeReader.getOriginalFilenameImpl(this.getNativeResourceHandle());
    }

    public boolean isRGBA() {
        if (this.customVolumeReader) {
            return false;
        }
        return SoVolumeReader.isRGBAImpl(this.getNativeResourceHandle());
    }

    static {
        JarInitializer.checkInit();
    }

    public static class DataInfo {
        public SbBox3f size;
        public SoDataSet.DataTypes type;
        public SbVec3i32 dim;
        public ReadErrors readError;

        static {
            JniInitializer.checkInit();
        }
    }

    public static enum ReadErrors implements IntegerValuedEnum
    {
        RD_NO_ERROR(ReadErrors.getRDNOERROR()),
        RD_FILE_NOT_FOUND_ERROR(ReadErrors.getRDFILENOTFOUNDERROR()),
        RD_INVALID_DATA_ERROR(ReadErrors.getRDINVALIDDATAERROR()),
        RD_UNSUPPORTED_DATA_TYPE_ERROR(ReadErrors.getRDUNSUPPORTEDDATATYPEERROR()),
        RD_FILE_FORMAT_NOT_VALID_ERROR(ReadErrors.getRDFILEFORMATNOTVALIDERROR()),
        RD_UNKNOWN_ERROR(ReadErrors.getRDUNKNOWNERROR());

        private int value;

        private static int getRDFILEFORMATNOTVALIDERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDFILEFORMATNOTVALIDERRORNative();
        }

        private static native int getRDFILEFORMATNOTVALIDERRORNative();

        private static int getRDUNSUPPORTEDDATATYPEERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDUNSUPPORTEDDATATYPEERRORNative();
        }

        private ReadErrors(int n2) {
            this.value = n2;
        }

        private static int getRDUNKNOWNERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDUNKNOWNERRORNative();
        }

        private static native int getRDUNKNOWNERRORNative();

        private static native int getRDUNSUPPORTEDDATATYPEERRORNative();

        private static native int getRDFILENOTFOUNDERRORNative();

        private static int getRDNOERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDNOERRORNative();
        }

        private static native int getRDNOERRORNative();

        private static int getRDINVALIDDATAERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDINVALIDDATAERRORNative();
        }

        private static native int getRDINVALIDDATAERRORNative();

        private static int getRDFILENOTFOUNDERROR() {
            JniInitializer.checkInit();
            return ReadErrors.getRDFILENOTFOUNDERRORNative();
        }

        public static ReadErrors valueOf(int n) {
            return (ReadErrors)IntegerValuedEnumHelper.fromIntValue(ReadErrors.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum ReaderTypes implements IntegerValuedEnum
    {
        NO_READER(ReaderTypes.getNOREADER()),
        AM(ReaderTypes.getAM()),
        AVS(ReaderTypes.getAVS()),
        DICOM(ReaderTypes.getDICOM()),
        GENERIC(ReaderTypes.getGENERIC()),
        LDM(ReaderTypes.getLDM()),
        MEMORY(ReaderTypes.getMEMORY()),
        RASTERSTACK(ReaderTypes.getRASTERSTACK()),
        SEGY(ReaderTypes.getSEGY()),
        VOL(ReaderTypes.getVOL()),
        VOX(ReaderTypes.getVOX()),
        TIFF(ReaderTypes.getTIFF()),
        MRC(ReaderTypes.getMRC());

        private int value;

        private static int getSEGY() {
            JniInitializer.checkInit();
            return ReaderTypes.getSEGYNative();
        }

        private static native int getVOLNative();

        private static int getVOL() {
            JniInitializer.checkInit();
            return ReaderTypes.getVOLNative();
        }

        private static native int getRASTERSTACKNative();

        private static int getRASTERSTACK() {
            JniInitializer.checkInit();
            return ReaderTypes.getRASTERSTACKNative();
        }

        private static native int getSEGYNative();

        private static native int getVOXNative();

        private static native int getMRCNative();

        private static int getMRC() {
            JniInitializer.checkInit();
            return ReaderTypes.getMRCNative();
        }

        private ReaderTypes(int n2) {
            this.value = n2;
        }

        private static int getVOX() {
            JniInitializer.checkInit();
            return ReaderTypes.getVOXNative();
        }

        private static native int getTIFFNative();

        private static int getTIFF() {
            JniInitializer.checkInit();
            return ReaderTypes.getTIFFNative();
        }

        private static int getMEMORY() {
            JniInitializer.checkInit();
            return ReaderTypes.getMEMORYNative();
        }

        private static int getAM() {
            JniInitializer.checkInit();
            return ReaderTypes.getAMNative();
        }

        private static native int getAVSNative();

        private static int getAVS() {
            JniInitializer.checkInit();
            return ReaderTypes.getAVSNative();
        }

        private static native int getNOREADERNative();

        private static int getNOREADER() {
            JniInitializer.checkInit();
            return ReaderTypes.getNOREADERNative();
        }

        private static native int getAMNative();

        private static native int getDICOMNative();

        private static native int getLDMNative();

        private static int getLDM() {
            JniInitializer.checkInit();
            return ReaderTypes.getLDMNative();
        }

        private static native int getMEMORYNative();

        private static int getDICOM() {
            JniInitializer.checkInit();
            return ReaderTypes.getDICOMNative();
        }

        private static native int getGENERICNative();

        private static int getGENERIC() {
            JniInitializer.checkInit();
            return ReaderTypes.getGENERICNative();
        }

        public static ReaderTypes valueOf(int n) {
            return (ReaderTypes)IntegerValuedEnumHelper.fromIntValue(ReaderTypes.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CoordinateTypes implements IntegerValuedEnum
    {
        COORDINATES_UNIFORM(CoordinateTypes.getCOORDINATESUNIFORM()),
        COORDINATES_RECTILINEAR(CoordinateTypes.getCOORDINATESRECTILINEAR());

        private int value;

        private static int getCOORDINATESRECTILINEAR() {
            JniInitializer.checkInit();
            return CoordinateTypes.getCOORDINATESRECTILINEARNative();
        }

        private CoordinateTypes(int n2) {
            this.value = n2;
        }

        private static native int getCOORDINATESRECTILINEARNative();

        private static native int getCOORDINATESUNIFORMNative();

        private static int getCOORDINATESUNIFORM() {
            JniInitializer.checkInit();
            return CoordinateTypes.getCOORDINATESUNIFORMNative();
        }

        public static CoordinateTypes valueOf(int n) {
            return (CoordinateTypes)IntegerValuedEnumHelper.fromIntValue(CoordinateTypes.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Axis implements IntegerValuedEnum
    {
        X(Axis.getX()),
        Y(Axis.getY()),
        Z(Axis.getZ());

        private int value;

        private static native int getZNative();

        private static int getZ() {
            JniInitializer.checkInit();
            return Axis.getZNative();
        }

        private Axis(int n2) {
            this.value = n2;
        }

        private static int getY() {
            JniInitializer.checkInit();
            return Axis.getYNative();
        }

        private static native int getXNative();

        private static int getX() {
            JniInitializer.checkInit();
            return Axis.getXNative();
        }

        private static native int getYNative();

        public static Axis valueOf(int n) {
            return (Axis)IntegerValuedEnumHelper.fromIntValue(Axis.class, (int)n);
        }

        public int getValue() {
            return this.value;
        }
    }
}

