/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.medical.nodes;

import com.openinventor.inventor.IntegerValuedEnum;
import com.openinventor.inventor.SbBox3f;
import com.openinventor.inventor.SbColor;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.actions.SoAction;
import com.openinventor.inventor.actions.SoGetBoundingBoxAction;
import com.openinventor.inventor.actions.SoHandleEventAction;
import com.openinventor.inventor.actions.SoSearchAction;
import com.openinventor.inventor.elements.SoViewportRegionElement;
import com.openinventor.inventor.fields.SoField;
import com.openinventor.inventor.fields.SoFieldContainer;
import com.openinventor.inventor.fields.SoSFBool;
import com.openinventor.inventor.fields.SoSFColor;
import com.openinventor.inventor.fields.SoSFEnum;
import com.openinventor.inventor.fields.SoSFFloat;
import com.openinventor.inventor.fields.SoSFString;
import com.openinventor.inventor.fields.SoSFVec3f;
import com.openinventor.inventor.misc.SoState;
import com.openinventor.inventor.nodes.SoAnnotation;
import com.openinventor.inventor.nodes.SoBBox;
import com.openinventor.inventor.nodes.SoCallback;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoFont;
import com.openinventor.inventor.nodes.SoLightModel;
import com.openinventor.inventor.nodes.SoLineSet;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoOrthographicCamera;
import com.openinventor.inventor.nodes.SoPickStyle;
import com.openinventor.inventor.nodes.SoSeparator;
import com.openinventor.inventor.nodes.SoSwitch;
import com.openinventor.inventor.nodes.SoText2;
import com.openinventor.inventor.nodes.SoTextProperty;
import com.openinventor.inventor.nodes.SoTranslation;
import com.openinventor.inventor.nodes.SoVertexProperty;
import com.openinventor.inventor.sensors.SoNodeSensor;
import java.util.Arrays;

public class TextBox
extends SoAnnotation {
    public SoSFVec3f position = new SoSFVec3f((SoFieldContainer)this, "position", SoField.FieldTypes.EXPOSED_FIELD, new SbVec3f(0.0f, 0.0f, 0.0f));
    public SoSFEnum<AlignmentH> alignmentH;
    public SoSFEnum<AlignmentV> alignmentV;
    public SoSFEnum<AlignmentH> textAlignH;
    public SoSFString fontName = new SoSFString((SoFieldContainer)this, "fontName", SoField.FieldTypes.EXPOSED_FIELD, "Arial:Bold");
    public SoSFFloat fontSize;
    public SoSFBool border;
    public SoSFColor borderColor;
    protected SoFont _fontNode;
    protected SoLineSet _borderGeom;
    protected SoSwitch _fontSwitch;
    protected SoSwitch _borderSwitch;
    protected SoText2 _textNode;
    protected SoTranslation _tranNode;
    protected SoSeparator _textSep;
    protected boolean _isModified = true;
    protected SbViewportRegion _curViewport;
    protected SbBox3f _curBBox;
    protected SoNodeSensor _nodeSensor;
    protected SoTextProperty _prop;

    public void setLine(String string, int n) {
        if (n < 0) {
            return;
        }
        if (string.length() <= 0) {
            this._textNode.string.set1Value(n, "");
        } else {
            this._textNode.string.set1Value(n, string);
        }
    }

    public void addLine(String string) {
        int n = this._textNode.string.getNum();
        if (string.length() <= 0) {
            this._textNode.string.set1Value(n, "");
        } else {
            this._textNode.string.set1Value(n, string);
        }
    }

    public int getNumLines() {
        return this._textNode.string.getNum();
    }

    public TextBox() {
        this.alignmentH = new SoSFEnum((SoFieldContainer)this, "alignmentH", SoField.FieldTypes.EXPOSED_FIELD, AlignmentH.class, (Enum)AlignmentH.LEFT);
        this.alignmentV = new SoSFEnum((SoFieldContainer)this, "alignmentV", SoField.FieldTypes.EXPOSED_FIELD, AlignmentV.class, (Enum)AlignmentV.TOP);
        this.textAlignH = new SoSFEnum((SoFieldContainer)this, "textAlignH", SoField.FieldTypes.EXPOSED_FIELD, AlignmentH.class, (Enum)AlignmentH.LEFT);
        this.fontSize = new SoSFFloat((SoFieldContainer)this, "fontSize", SoField.FieldTypes.EXPOSED_FIELD, 15.0f);
        this.border = new SoSFBool((SoFieldContainer)this, "border", SoField.FieldTypes.EXPOSED_FIELD, false);
        this.borderColor = new SoSFColor((SoFieldContainer)this, "borderColor", SoField.FieldTypes.EXPOSED_FIELD, new SbColor(1.0f, 1.0f, 1.0f));
        this._curViewport = new SbViewportRegion(0, 0);
        this._curBBox = new SbBox3f();
        this.setName("Tooltip");
        this.buildSceneGraph();
        this._nodeSensor = new SoNodeSensor(new Runnable(){

            @Override
            public void run() {
                int n;
                TextBox.this._isModified = true;
                TextBox.this.enableNotify(false);
                int n2 = n = TextBox.this.border.getValue() ? 0 : -1;
                if (TextBox.this._borderSwitch.whichChild.getValue() != n) {
                    TextBox.this._borderSwitch.whichChild.setValue(n);
                }
                int n3 = TextBox.this.borderColor.getValue().getPackedValue();
                SoVertexProperty soVertexProperty = (SoVertexProperty)TextBox.this._borderGeom.vertexProperty.getValue();
                if (soVertexProperty.orderedRGBA.getValueAt(0) != n3) {
                    soVertexProperty.orderedRGBA.set1Value(0, n3);
                }
                TextBox.this.enableNotify(true);
            }
        });
        this._nodeSensor.setPriority(0L);
        this._nodeSensor.attach((SoNode)this);
    }

    protected void buildSceneGraph() {
        SoCallback soCallback = new SoCallback();
        soCallback.setCallback(new SoCallback.CB(){

            public void invoke(SoAction soAction) {
                if (soAction instanceof SoHandleEventAction || soAction instanceof SoSearchAction || soAction instanceof SoGetBoundingBoxAction) {
                    return;
                }
                SoState soState = soAction.getState();
                SbViewportRegion sbViewportRegion = SoViewportRegionElement.get((SoState)soState);
                if (!TextBox.this._isModified && sbViewportRegion.equals((Object)TextBox.this._curViewport)) {
                    return;
                }
                TextBox.this._curViewport = sbViewportRegion;
                TextBox.this.updatePosAndGeom(soState);
            }
        });
        this.addChild((SoNode)soCallback);
        SoBBox soBBox = new SoBBox();
        soBBox.mode.setValue((Enum)SoBBox.Modes.NO_BOUNDING_BOX);
        this.addChild((SoNode)soBBox);
        SoLightModel soLightModel = new SoLightModel();
        soLightModel.model.setValue((Enum)SoLightModel.Models.BASE_COLOR);
        this.addChild((SoNode)soLightModel);
        SoPickStyle soPickStyle = new SoPickStyle();
        soPickStyle.style.setValue((Enum)SoPickStyle.Styles.UNPICKABLE);
        this.addChild((SoNode)soPickStyle);
        SoOrthographicCamera soOrthographicCamera = new SoOrthographicCamera();
        soOrthographicCamera.viewportMapping.setValue((Enum)SoCamera.ViewportMappings.LEAVE_ALONE);
        this.addChild((SoNode)soOrthographicCamera);
        this._textSep = new SoSeparator();
        this.addChild((SoNode)this._textSep);
        this._tranNode = new SoTranslation();
        this._tranNode.translation.setValue(this.position.getValue());
        this._textSep.addChild((SoNode)this._tranNode);
        this._prop = new SoTextProperty();
        this._prop.alignmentH.connectFrom(this.textAlignH);
        this._prop.alignmentV.setValue((Enum)SoTextProperty.AlignmentVs.TOP);
        this._textSep.addChild((SoNode)this._prop);
        this._fontSwitch = new SoSwitch();
        this._fontSwitch.whichChild.setValue(0);
        this._textSep.addChild((SoNode)this._fontSwitch);
        this._fontNode = new SoFont();
        this._fontNode.size.connectFrom((SoField)this.fontSize);
        this._fontNode.name.connectFrom((SoField)this.fontName);
        this._fontNode.renderStyle.setValue((Enum)SoFont.RenderStyles.TEXTURE);
        this._fontSwitch.addChild((SoNode)this._fontNode);
        this._textNode = new SoText2();
        this._textNode.string.deleteValues(0);
        this._textNode.spacing.setValue(1.1f);
        this._textNode.justification.setValue((Enum)SoText2.Justifications.INHERITED);
        this._textSep.addChild((SoNode)this._textNode);
        SoSeparator soSeparator = new SoSeparator();
        this.addChild((SoNode)soSeparator);
        this._borderSwitch = new SoSwitch();
        this._borderSwitch.whichChild.setValue(this.border.getValue() ? 0 : -1);
        soSeparator.addChild((SoNode)this._borderSwitch);
        SoVertexProperty soVertexProperty = new SoVertexProperty();
        int n = this.borderColor.getValue().getPackedValue();
        soVertexProperty.orderedRGBA.set1Value(0, n);
        this._borderGeom = new SoLineSet();
        this._borderGeom.vertexProperty.setValue((SoNode)soVertexProperty);
        this._borderSwitch.addChild((SoNode)this._borderGeom);
    }

    public SoNode.RenderModes getRenderEngineMode() {
        return SoNode.RenderModes.OIV_OPENINVENTOR_RENDERING;
    }

    protected void updatePosAndGeom(SoState soState) {
        SbViewportRegion sbViewportRegion = this._curViewport;
        if (soState != null) {
            sbViewportRegion = SoViewportRegionElement.get((SoState)soState);
        }
        SbVec3f sbVec3f = new SbVec3f(-0.99f, 0.99f, 0.0f);
        boolean bl = this._tranNode.enableNotify(false);
        SbVec3f sbVec3f2 = this._tranNode.translation.getValue();
        this._tranNode.translation.setValue(sbVec3f);
        SoGetBoundingBoxAction soGetBoundingBoxAction = new SoGetBoundingBoxAction(sbViewportRegion);
        soGetBoundingBoxAction.apply((SoNode)this._textSep);
        SbBox3f sbBox3f = soGetBoundingBoxAction.getBoundingBox();
        SbVec3f sbVec3f3 = this.position.getValue();
        SbVec3f sbVec3f4 = sbBox3f.getSize();
        SbVec3f sbVec3f5 = new SbVec3f(0.0f, 0.0f, 0.0f);
        if (this.alignmentH.getValue() == AlignmentH.LEFT.getValue()) {
            if (this.textAlignH.getValue() == AlignmentH.CENTER.getValue()) {
                sbVec3f5.setX(0.5f * sbVec3f4.getX());
            } else if (this.textAlignH.getValue() == AlignmentH.RIGHT.getValue()) {
                sbVec3f5.setX(sbVec3f4.getX());
            }
        } else if (this.alignmentH.getValue() == AlignmentH.CENTER.getValue()) {
            if (this.textAlignH.getValue() == AlignmentH.LEFT.getValue()) {
                sbVec3f5.setX(-0.5f * sbVec3f4.getX());
            } else if (this.textAlignH.getValue() == AlignmentH.RIGHT.getValue()) {
                sbVec3f5.setX(0.5f * sbVec3f4.getX());
            }
        } else if (this.alignmentH.getValue() == AlignmentH.RIGHT.getValue()) {
            if (this.textAlignH.getValue() == AlignmentH.LEFT.getValue()) {
                sbVec3f5.setX(-sbVec3f4.getX());
            } else if (this.textAlignH.getValue() == AlignmentH.CENTER.getValue()) {
                sbVec3f5.setX(-0.5f * sbVec3f4.getX());
            }
        }
        if (this.alignmentV.getValue() != AlignmentV.TOP.getValue()) {
            if (this.alignmentV.getValue() == AlignmentV.MIDDLE.getValue()) {
                sbVec3f5.setY(0.5f * sbVec3f4.getY());
            } else if (this.alignmentV.getValue() == AlignmentV.BOTTOM.getValue()) {
                sbVec3f5.setY(sbVec3f4.getY());
            }
        }
        sbVec3f3.add(sbVec3f5);
        this._tranNode.translation.setValue(sbVec3f3);
        this._tranNode.enableNotify(bl);
        if (!sbVec3f3.equals((Object)sbVec3f2)) {
            this._tranNode.touch();
        }
        sbVec3f.add(sbVec3f3);
        SbVec3f sbVec3f6 = sbBox3f.getMin().minus(sbVec3f.plus(sbVec3f3));
        SbVec3f sbVec3f7 = sbBox3f.getMax().minus(sbVec3f.plus(sbVec3f3));
        sbBox3f.setBounds(sbVec3f6, sbVec3f7);
        SoVertexProperty soVertexProperty = (SoVertexProperty)this._borderGeom.vertexProperty.getValue();
        this.updateBorderGeom(soVertexProperty, sbBox3f);
        this._curBBox = sbBox3f;
        this._curViewport = sbViewportRegion;
        this._isModified = false;
    }

    protected void updateBorderGeom(SoVertexProperty soVertexProperty, SbBox3f sbBox3f) {
        SbVec3f sbVec3f = sbBox3f.getMin();
        SbVec3f sbVec3f2 = sbBox3f.getMax();
        SbVec3f sbVec3f3 = sbBox3f.getSize();
        sbVec3f.setX(sbVec3f.getX() - 0.02f * sbVec3f3.getX());
        sbVec3f2.setX(sbVec3f2.getX() + 0.02f * sbVec3f3.getX());
        sbVec3f2.setY(sbVec3f2.getY() + 0.02f * sbVec3f3.getY());
        Object[] objectArray = new SbVec3f[]{new SbVec3f(sbVec3f.getX(), sbVec3f.getY(), sbVec3f.getZ()), new SbVec3f(sbVec3f2.getX(), sbVec3f.getY(), sbVec3f.getZ()), new SbVec3f(sbVec3f2.getX(), sbVec3f2.getY(), sbVec3f2.getZ()), new SbVec3f(sbVec3f.getX(), sbVec3f2.getY(), sbVec3f.getZ()), new SbVec3f(sbVec3f.getX(), sbVec3f.getY(), sbVec3f.getZ())};
        if (!Arrays.equals(objectArray, soVertexProperty.vertex.getValues(0))) {
            soVertexProperty.vertex.setValues(0, (SbVec3f[])objectArray);
        }
    }

    public static enum AlignmentH implements IntegerValuedEnum
    {
        LEFT(SoTextProperty.AlignmentHs.LEFT.getValue()),
        CENTER(SoTextProperty.AlignmentHs.CENTER.getValue()),
        RIGHT(SoTextProperty.AlignmentHs.RIGHT.getValue());

        private final int _alignmentH;

        private AlignmentH(int n2) {
            this._alignmentH = n2;
        }

        public int getValue() {
            return this._alignmentH;
        }
    }

    public static enum AlignmentV implements IntegerValuedEnum
    {
        TOP(SoTextProperty.AlignmentVs.TOP.getValue()),
        MIDDLE(SoTextProperty.AlignmentVs.HALF.getValue()),
        BOTTOM(SoTextProperty.AlignmentVs.BOTTOM.getValue());

        private final int _alignmentV;

        private AlignmentV(int n2) {
            this._alignmentV = n2;
        }

        public int getValue() {
            return this._alignmentV;
        }
    }
}

