/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt;

import com.openinventor.inventor.sensors.SoSystemTimer;
import com.openinventor.inventor.sensors.SoSystemTimerTask;
import org.eclipse.swt.widgets.Display;

public class Timer
extends SoSystemTimer {
    private TimerRunnable m_timerRunnable = new TimerRunnable();
    private SoSystemTimerTask m_task = null;
    private boolean m_isRepeat = false;
    private int m_delay = 0;
    private boolean m_isPending = false;

    public void start() {
        Display.getDefault().timerExec(this.m_delay, (Runnable)this.m_timerRunnable);
        this.setPending(true);
    }

    public void stop() {
        Display.getDefault().timerExec(-1, (Runnable)this.m_timerRunnable);
        this.setPending(false);
    }

    private synchronized int getDelay() {
        return this.m_delay;
    }

    public synchronized void setDelay(int n) {
        this.m_delay = n;
    }

    public synchronized boolean isPending() {
        return this.m_isPending;
    }

    private synchronized void setPending(boolean bl) {
        this.m_isPending = bl;
    }

    private synchronized boolean isRepeat() {
        return this.m_isRepeat;
    }

    public void setRepeat(boolean bl) {
        this.m_isRepeat = bl;
    }

    public void setTask(SoSystemTimerTask soSystemTimerTask) {
        this.m_task = soSystemTimerTask;
    }

    private class TimerRunnable
    implements Runnable {
        private TimerRunnable() {
        }

        @Override
        public void run() {
            if (Timer.this.m_task != null) {
                Timer.this.m_task.run();
            }
            Timer.this.setPending(false);
            if (Timer.this.isRepeat()) {
                Display.getDefault().timerExec(Timer.this.getDelay(), (Runnable)this);
            }
        }
    }
}

