/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.openinventor.inventor.SbEventListener;
import com.openinventor.inventor.SbVec3f;
import com.openinventor.inventor.SbViewportRegion;
import com.openinventor.inventor.events.SoEvent;
import com.openinventor.inventor.events.SoKeyboardEvent;
import com.openinventor.inventor.events.SoLocation2Event;
import com.openinventor.inventor.events.SoMouseButtonEvent;
import com.openinventor.inventor.events.SoMouseWheelEvent;
import com.openinventor.inventor.nodes.SoCamera;
import com.openinventor.inventor.nodes.SoGroup;
import com.openinventor.inventor.nodes.SoNode;
import com.openinventor.inventor.nodes.SoStereoCamera;
import com.openinventor.inventor.viewercomponents.SiRenderArea;
import com.openinventor.inventor.viewercomponents.nodes.SceneInteractor;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.RenderArea;
import com.openinventor.inventor.viewercomponents.swt.glcanvas.renderareas.SWTEventToSoEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.widgets.Composite;

public class RenderAreaInteractive
extends RenderArea
implements MouseListener,
MouseMoveListener,
MouseWheelListener,
MouseTrackListener,
KeyListener {
    protected SceneInteractor m_rootSceneGraph;
    private SoGroup m_appSceneGraph;
    private ClippingPlanesAdjustMode m_clippingMode;

    public RenderAreaInteractive(Composite composite, int n) {
        super(composite, n);
        this.init(true);
    }

    public RenderAreaInteractive(Composite composite, int n, GLCapabilities gLCapabilities) {
        super(composite, n, gLCapabilities);
        this.init(true);
    }

    protected RenderAreaInteractive(Composite composite, int n, boolean bl) {
        super(composite, n);
        this.init(bl);
    }

    protected RenderAreaInteractive(Composite composite, int n, boolean bl, GLCapabilities gLCapabilities) {
        super(composite, n, gLCapabilities);
        this.init(bl);
    }

    private void init(boolean bl) {
        this.m_clippingMode = ClippingPlanesAdjustMode.AUTO;
        if (bl) {
            this.m_rootSceneGraph = new SceneInteractor();
            this.buildSceneGraph();
        }
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    protected void buildSceneGraph() {
        this.m_appSceneGraph = new SoGroup();
        this.m_rootSceneGraph.addChild((SoNode)this.m_appSceneGraph);
        super.setSceneGraph((SoNode)this.m_rootSceneGraph);
    }

    @Override
    public void setSceneGraph(SoNode soNode) {
        this.m_appSceneGraph.removeAllChildren();
        if (soNode != null) {
            this.m_appSceneGraph.addChild(soNode);
        }
    }

    @Override
    protected void render() {
        if (this.m_clippingMode == ClippingPlanesAdjustMode.AUTO) {
            this.m_rootSceneGraph.adjustClippingPlanes(this.m_renderAreaCore.getSceneManager().getViewportRegion());
        }
        super.render();
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        super.init(gLAutoDrawable);
        this.m_renderAreaCore.onStartRender().addEventListener((SbEventListener)new SbEventListener<SiRenderArea.RenderEventArg>(){

            public void onEvent(SiRenderArea.RenderEventArg renderEventArg) {
                RenderAreaInteractive.this.display();
            }
        });
    }

    public ClippingPlanesAdjustMode getClippingPlanesAdjustMode() {
        return this.m_clippingMode;
    }

    public void setClippingPlanesAdjustMode(ClippingPlanesAdjustMode clippingPlanesAdjustMode) {
        if (this.m_clippingMode != clippingPlanesAdjustMode) {
            this.m_clippingMode = clippingPlanesAdjustMode;
            this.scheduleRedraw();
        }
    }

    @Deprecated
    public SceneInteractor getRootSceneGraph() {
        return this.m_rootSceneGraph;
    }

    public SceneInteractor getSceneInteractor() {
        return this.m_rootSceneGraph;
    }

    public void viewAll(SbViewportRegion sbViewportRegion) {
        this.m_rootSceneGraph.viewAll(sbViewportRegion);
    }

    public void viewAxis(SbVec3f sbVec3f, SbVec3f sbVec3f2) {
        this.m_rootSceneGraph.viewAxis(sbVec3f, sbVec3f2);
    }

    public void saveCamera() {
        this.m_rootSceneGraph.getCameraInteractor().pushCamera();
    }

    public void restoreCamera() {
        this.m_rootSceneGraph.getCameraInteractor().popCamera();
    }

    public void setCameraType(SceneInteractor.CameraMode cameraMode) {
        this.m_rootSceneGraph.setCameraMode(cameraMode);
    }

    @Override
    public void activateStereo(boolean bl) {
        if (bl && !this.isStereoSupported()) {
            throw new UnsupportedOperationException("Cannot activate stereo: current camera is not a SoStereoCamera!");
        }
        super.activateStereo(bl);
    }

    public boolean isStereoSupported() {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        return soCamera instanceof SoStereoCamera;
    }

    public void setStereoCameraOffset(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.offset.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    public void setStereoCameraBalance(float f) {
        SoCamera soCamera = this.m_rootSceneGraph.getCamera();
        try {
            SoStereoCamera soStereoCamera = (SoStereoCamera)soCamera;
            soStereoCamera.balance.setValue(f);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException("Current camera is not a SoStereoCamera!");
        }
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoMouseButtonEvent soMouseButtonEvent = SWTEventToSoEvent.getMousePressEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseScrolled(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoMouseWheelEvent soMouseWheelEvent = SWTEventToSoEvent.getMouseWheelEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soMouseWheelEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoLocation2Event soLocation2Event = SWTEventToSoEvent.getMouseMoveEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoMouseButtonEvent soMouseButtonEvent = SWTEventToSoEvent.getMouseDoubleClickEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoMouseButtonEvent soMouseButtonEvent = SWTEventToSoEvent.getMouseReleaseEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soMouseButtonEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseEnter(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoLocation2Event soLocation2Event = SWTEventToSoEvent.getMouseEnterEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseExit(MouseEvent mouseEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoLocation2Event soLocation2Event = SWTEventToSoEvent.getMouseLeaveEvent(mouseEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soLocation2Event);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void mouseHover(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoKeyboardEvent soKeyboardEvent = SWTEventToSoEvent.getKeyPressEvent(keyEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soKeyboardEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.m_renderAreaCore != null) {
            try {
                this.m_renderAreaCore.isDisposable();
                SoKeyboardEvent soKeyboardEvent = SWTEventToSoEvent.getKeyReleaseEvent(keyEvent, (Composite)this);
                this.m_renderAreaCore.processEvent((SoEvent)soKeyboardEvent);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static enum ClippingPlanesAdjustMode {
        AUTO,
        MANUAL;

    }
}

