/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.inventor.viewercomponents.swt.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SWTResourceManager {
    private static Map<RGB, Color> m_colorMap = new HashMap<RGB, Color>();
    private static Map<String, Image> m_imageMap = new HashMap<String, Image>();
    private static final int MISSING_IMAGE_SIZE = 10;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    protected static final int LAST_CORNER_KEY = 5;
    private static Map<Image, Map<Image, Image>>[] m_decoratedImageMap = new Map[5];
    private static Map<String, Font> m_fontMap = new HashMap<String, Font>();
    private static Map<Font, Font> m_fontToBoldFontMap = new HashMap<Font, Font>();
    private static Map<Integer, Cursor> m_idToCursorMap = new HashMap<Integer, Cursor>();

    public static Color getColor(int n) {
        Display display = Display.getCurrent();
        return display.getSystemColor(n);
    }

    public static Color getColor(int n, int n2, int n3) {
        return SWTResourceManager.getColor(new RGB(n, n2, n3));
    }

    public static Color getColor(RGB rGB) {
        Color color = m_colorMap.get(rGB);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rGB);
            m_colorMap.put(rGB, color);
        }
        return color;
    }

    public static void disposeColors() {
        for (Color color : m_colorMap.values()) {
            color.dispose();
        }
        m_colorMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Image getImage(InputStream inputStream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData imageData = new ImageData(inputStream);
            if (imageData.transparentPixel > 0) {
                Image image = new Image((Device)display, imageData, imageData.getTransparencyMask());
                return image;
            }
            Image image = new Image((Device)display, imageData);
            return image;
        }
        finally {
            inputStream.close();
        }
    }

    public static Image getImage(String string) {
        Image image = m_imageMap.get(string);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(new FileInputStream(string));
                m_imageMap.put(string, image);
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(string, image);
            }
        }
        return image;
    }

    public static Image getImage(Class<?> clazz, String string) {
        String string2 = clazz.getName() + "|" + string;
        Image image = m_imageMap.get(string2);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(clazz.getResourceAsStream(string));
                m_imageMap.put(string2, image);
            }
            catch (Exception exception) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(string2, image);
            }
        }
        return image;
    }

    private static Image getMissingImage() {
        Image image = new Image((Device)Display.getCurrent(), 10, 10);
        GC gC = new GC((Drawable)image);
        gC.setBackground(SWTResourceManager.getColor(3));
        gC.fillRectangle(0, 0, 10, 10);
        gC.dispose();
        return image;
    }

    public static Image decorateImage(Image image, Image image2) {
        return SWTResourceManager.decorateImage(image, image2, 4);
    }

    public static Image decorateImage(Image image, Image image2, int n) {
        Image image3;
        Map<Image, Image> map;
        if (n <= 0 || n >= 5) {
            throw new IllegalArgumentException("Wrong decorate corner");
        }
        Map<Image, Map<Image, Image>> map2 = m_decoratedImageMap[n];
        if (map2 == null) {
            SWTResourceManager.m_decoratedImageMap[n] = map2 = new HashMap<Image, Map<Image, Image>>();
        }
        if ((map = map2.get(image)) == null) {
            map = new HashMap<Image, Image>();
            map2.put(image, map);
        }
        if ((image3 = map.get(image2)) == null) {
            Rectangle rectangle = image.getBounds();
            Rectangle rectangle2 = image2.getBounds();
            image3 = new Image((Device)Display.getCurrent(), rectangle.width, rectangle.height);
            GC gC = new GC((Drawable)image3);
            gC.drawImage(image, 0, 0);
            if (n == 1) {
                gC.drawImage(image2, 0, 0);
            } else if (n == 2) {
                gC.drawImage(image2, rectangle.width - rectangle2.width, 0);
            } else if (n == 3) {
                gC.drawImage(image2, 0, rectangle.height - rectangle2.height);
            } else if (n == 4) {
                gC.drawImage(image2, rectangle.width - rectangle2.width, rectangle.height - rectangle2.height);
            }
            gC.dispose();
            map.put(image2, image3);
        }
        return image3;
    }

    public static void disposeImages() {
        for (Image object : m_imageMap.values()) {
            object.dispose();
        }
        m_imageMap.clear();
        for (int i = 0; i < m_decoratedImageMap.length; ++i) {
            Map<Image, Map<Image, Image>> map = m_decoratedImageMap[i];
            if (map == null) continue;
            for (Map<Image, Image> map2 : map.values()) {
                for (Image image : map2.values()) {
                    image.dispose();
                }
                map2.clear();
            }
            map.clear();
        }
    }

    public static Font getFont(String string, int n, int n2) {
        return SWTResourceManager.getFont(string, n, n2, false, false);
    }

    public static Font getFont(String string, int n, int n2, boolean bl, boolean bl2) {
        String string2 = string + "|" + n + "|" + n2 + "|" + bl + "|" + bl2;
        Font font = m_fontMap.get(string2);
        if (font == null) {
            FontData fontData = new FontData(string, n, n2);
            if (bl || bl2) {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object object = FontData.class.getField("data").get(fontData);
                    if (object != null && clazz != null) {
                        if (bl) {
                            clazz.getField("lfStrikeOut").set(object, (byte)1);
                        }
                        if (bl2) {
                            clazz.getField("lfUnderline").set(object, (byte)1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("Unable to set underline or strikeout (probably on a non-Windows platform). " + String.valueOf(throwable));
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            m_fontMap.put(string2, font);
        }
        return font;
    }

    public static Font getBoldFont(Font font) {
        Font font2 = m_fontToBoldFontMap.get(font);
        if (font2 == null) {
            FontData[] fontDataArray = font.getFontData();
            FontData fontData = fontDataArray[0];
            font2 = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            m_fontToBoldFontMap.put(font, font2);
        }
        return font2;
    }

    public static void disposeFonts() {
        for (Font font : m_fontMap.values()) {
            font.dispose();
        }
        m_fontMap.clear();
        for (Font font : m_fontToBoldFontMap.values()) {
            font.dispose();
        }
        m_fontToBoldFontMap.clear();
    }

    public static Cursor getCursor(int n) {
        Integer n2 = n;
        Cursor cursor = m_idToCursorMap.get(n2);
        if (cursor == null) {
            cursor = new Cursor((Device)Display.getDefault(), n);
            m_idToCursorMap.put(n2, cursor);
        }
        return cursor;
    }

    public static void disposeCursors() {
        for (Cursor cursor : m_idToCursorMap.values()) {
            cursor.dispose();
        }
        m_idToCursorMap.clear();
    }

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeFonts();
        SWTResourceManager.disposeCursors();
    }
}

