/*
 * Decompiled with CFR 0.152.
 */
package com.openinventor.internal;

import com.openinventor.internal.NativeTypeMap;
import com.openinventor.internal.ObjectManager;
import com.openinventor.inventor.Inventor;
import com.openinventor.inventor.SoPreferences;
import com.openinventor.inventor.errors.SoInternalError;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

class DynamicTypeManager {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String PACKAGE_SEPARATOR_REPLACEMENT = "__";
    private static final String INNER_CLASS_SEPARATOR = "$";
    private static final String INNER_CLASS_SEPARATOR_REPLACEMENT = "___";

    private DynamicTypeManager() {
    }

    static String getCompliantTypeName(String string) {
        return string.replace(PACKAGE_SEPARATOR, PACKAGE_SEPARATOR_REPLACEMENT).replace(INNER_CLASS_SEPARATOR, INNER_CLASS_SEPARATOR_REPLACEMENT);
    }

    static String getClassName(String string) {
        return string.replace(INNER_CLASS_SEPARATOR_REPLACEMENT, INNER_CLASS_SEPARATOR).replace(PACKAGE_SEPARATOR_REPLACEMENT, PACKAGE_SEPARATOR);
    }

    private static boolean findClass(String string) {
        try {
            Class.forName(string, false, DynamicTypeManager.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private static String handleUnknownType(String string) {
        Object object;
        Object object2;
        if (Inventor.VERBOSE_LEVEL > 0) {
            System.out.println("DEBUG JAVA, DynamicTypeManager.handleUnknownType: search for a managed type corresponding to name = " + string);
        }
        String[] stringArray = new String[]{"", "com.openinventor.volumeviz.nodes.", "com.openinventor.volumeviz.nodes.So", "com.openinventor.ldm.nodes.", "com.openinventor.ldm.nodes.So", "com.openinventor.meshviz.nodes.", "com.openinventor.meshviz.nodes.Po", "com.openinventor.scaleviz.nodes.", "com.openinventor.scaleviz.nodes.So", "com.openinventor.meshvizxlm.mapping.nodes.", "com.openinventor.meshvizxlm.mapping.nodes.Mo"};
        String string2 = DynamicTypeManager.getClassName(string);
        boolean bl = false;
        int n = 0;
        for (n = 0; !bl && n < stringArray.length; ++n) {
            bl = DynamicTypeManager.findClass(stringArray[n] + string2);
        }
        Class<?> clazz = null;
        if (bl) {
            try {
                clazz = Class.forName(stringArray[n - 1] + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                assert (false);
                classNotFoundException.printStackTrace();
            }
        } else {
            try {
                object2 = SoPreferences.getValue("OIV_USER_LIBS");
                if (object2 == null) {
                    throw new ClassNotFoundException(string2 + " class could not be found.");
                }
                object = ((String)object2).split(";");
                ArrayList<URL> arrayList = new ArrayList<URL>(((String[])object).length);
                for (int i = 0; i < ((String[])object).length; ++i) {
                    File file = new File(object[i]);
                    if (file.exists()) {
                        try {
                            arrayList.add(file.toURI().toURL());
                        }
                        catch (MalformedURLException malformedURLException) {
                            malformedURLException.printStackTrace();
                        }
                        continue;
                    }
                    System.err.println("The file or directory \"" + object[i] + "\" specified by OIV_USER_LIBS doesn't exist!");
                }
                URLClassLoader uRLClassLoader = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]));
                clazz = Class.forName(string2, true, uRLClassLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
        if (clazz != null && Inventor.class.isAssignableFrom(clazz) && (object = (Inventor)ObjectManager.newInstance(object2 = clazz.asSubclass(Inventor.class))) != null) {
            return NativeTypeMap.getNativeTypeName((Class<? extends Inventor>)object2);
        }
        return null;
    }

    private static long newInstance(String string) {
        Class<? extends Inventor> clazz = NativeTypeMap.getJavaClass(string);
        Inventor inventor = ObjectManager.newInstance(clazz);
        if (inventor == null) {
            return Inventor.ZeroHandle;
        }
        return inventor.getNativeResourceHandle();
    }

    private static <T> T newInstance(final Class<T> clazz) {
        Object t = AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object t;
                block9: {
                    t = null;
                    try {
                        Class<?> clazz2 = clazz.getEnclosingClass();
                        try {
                            if (clazz2 == null) {
                                t = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                                break block9;
                            }
                            Object obj = DynamicTypeManager.newInstance(clazz2);
                            Constructor constructor = clazz.getConstructor(clazz2);
                            t = constructor.newInstance(obj);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                            constructor.setAccessible(true);
                            t = constructor.newInstance(new Object[0]);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + String.valueOf(clazz) + " class does not define a default constructor.");
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        noSuchMethodException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + String.valueOf(clazz) + " class does not define a default constructor.");
                    }
                    catch (InstantiationException instantiationException) {
                        instantiationException.printStackTrace();
                        throw new SoInternalError("ObjectManager.createInstance: " + String.valueOf(clazz) + " class does not define a default constructor.");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        invocationTargetException.printStackTrace();
                    }
                }
                return t;
            }
        });
        return t;
    }
}

